# Arbitrary Command Injection via `--netrc-cmd` in yt-dlp

> **Severity:** High (CVSS 8.8)  
> **Affected Software:** [yt-dlp](https://github.com/yt-dlp/yt-dlp) >= 2023.06.21, < 2026.02.21  
> **Patched In:** 2026.02.21  
> **Advisory:** [GHSA-g3gw-q23r-pgqm](https://github.com/yt-dlp/yt-dlp/security/advisories/GHSA-g3gw-q23r-pgqm)  
> **CVE:** [CVE-2026-26331](https://nvd.nist.gov/vuln/detail/CVE-2026-26331)  

---

## Summary

yt-dlp’s `--netrc-cmd` command-line option (or `netrc_cmd` Python API parameter) can be abused to achieve arbitrary command execution when combined with a maliciously crafted URL. This allows an attacker to execute arbitrary shell commands on the user’s system.

---

## Details

The `--netrc-cmd` option allows users to execute a shell command to retrieve login credentials dynamically, optionally replacing a placeholder `{}` with the netrc "machine" value. Some extractors (e.g., `GetCourseRuIE`, `TeachableIE`, `TeachableCourseIE`) allow wildcard hostnames, which may contain shell-special characters. Because yt-dlp executes `--netrc-cmd` using `subprocess.Popen(shell=True)`, a malicious URL can inject arbitrary commands.

---

## PoC

```bash
yt-dlp --netrc-cmd "echo {}" "https://;touch /tmp/pwned;#.getcourse.ru/video"
```

---

## Impact

- **Attack Vector:** Network  
- **Attack Complexity:** Low  
- **Privileges Required:** None  
- **User Interaction:** Required  
- **Impact:** High confidentiality, integrity, and availability impact  

---

## Mitigation

- Upgrade yt-dlp to version **2026.02.21** or later.
- Avoid using `--netrc-cmd` or `netrc_cmd`.
- If unavoidable, do **not** pass placeholders (`{}`) to `--netrc-cmd`.

---

## References

- https://github.com/yt-dlp/yt-dlp/security/advisories/GHSA-g3gw-q23r-pgqm  
- https://nvd.nist.gov/vuln/detail/CVE-2026-26331  
- https://github.com/yt-dlp/yt-dlp/releases/tag/2026.02.21  
