# CVE-2026-26215 - manga-image-translator Pickle Deserialization RCE
## 👤 Author

### Mohammed Idrees Banyamer
Instagram: @banyamer_security
GitHub: @mbanyamer
![Python](https://img.shields.io/badge/python-3.6%2B-blue)
![Version](https://img.shields.io/badge/manga--image--translator-%3C%3Dbeta--0.3-red)
![CVE](https://img.shields.io/badge/CVE-2026--26215-brightgreen)
![CVSS](https://img.shields.io/badge/CVSS-9.3-critical)
![Author](https://img.shields.io/badge/Author-@banyamer_security-orange)

**Proof-of-Concept exploit for CVE-2026-26215** - Unauthenticated Remote Code Execution via unsafe Pickle deserialization in **manga-image-translator ≤ beta-0.3**.

---

## 🚨 Vulnerability Description

**CVE-2026-26215** is an unauthenticated remote code execution vulnerability in **manga-image-translator** versions ≤ beta-0.3 running in shared API mode.

The endpoints `/execute/{method_name}` and `/simple_execute/{method_name}` deserialize attacker-controlled request bodies using `pickle.loads()` without any validation. The nonce-based authentication mechanism is completely bypassed as it defaults to an empty string.

This allows:

- **Unauthenticated RCE** in server context
- **No user interaction** required
- **Full server compromise**

---

## 🎯 Affected Versions

| Status | Version |
|--------|---------|
| ❌ **Vulnerable** | manga-image-translator ≤ beta-0.3 |
| ✅ **Patched** | Not yet released |

**Tested on:** Docker (zyddnys/manga-image-translator:main), Linux

---

## 💥 Impact

| Vector | Description |
|--------|-------------|
| **CVSS v4** | 9.3 (Critical) - AV:N/AC:L/AT:N/PR:N/UI:N/VC:H/VI:H/VA:H |
| **Authentication** | None - Completely unauthenticated |
| **Attack Vector** | Network |
| **Complexity** | Low |

---

## 🔬 Technical Details

### Root Cause

1. **Unsafe deserialization** - `pickle.loads(await request.body())` called directly on attacker input
2. **Authentication bypass** - `self.nonce` defaults to `None`, skipping the nonce check entirely
3. **No input validation** - No restrictions on pickle payload size or content
4. **Public endpoints** - `/execute/` and `/simple_execute/` exposed without proper access controls

### Vulnerability Flow

```mermaid
graph LR
    A[Attacker crafts malicious pickle payload] --> B[Sends POST request to /execute/translate]
    B --> C[Server calls pickle.loads on request body]
    C --> D[__reduce__ method executes]
    D --> E[os.system called with attacker command]
    E --> F[Remote code execution]
