## 👤 Author

Mohammed Idrees Banyamer
Security Researcher

## 📌 Overview

This repository contains a Proof-of-Concept (PoC) exploit for **CVE-2026-25939**, a critical authorization bypass vulnerability in **FUXA** (open-source SCADA/ICS software). The vulnerability allows unauthenticated remote attackers to create, modify, and delete arbitrary scheduler entries, potentially leading to remote code execution and industrial control system manipulation.

## 🔥 Vulnerability Details

- **CVE ID**: CVE-2026-25939
- **CVSS Score**: 9.1 (Critical) - CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:C/C:H/I:H/A:H
- **Affected Versions**: FUXA >= 1.2.8, < 1.2.11
- **Patched Version**: FUXA v1.2.11+
- **Vulnerability Type**: Authorization Bypass
- **Attack Vector**: Remote, Unauthenticated

## 🎯 Technical Description

### Root Cause
The vulnerability exists in the `/api/scheduler` endpoint where guest user authentication checks were missing in both POST and DELETE handlers. The patch in v1.2.11 added explicit `authJwt.isGuestUser()` validation.

### Affected Endpoints
- `POST /api/scheduler` - Create/Modify schedulers
- `DELETE /api/scheduler` - Delete schedulers

### Impact
- ✅ Create malicious schedulers with arbitrary scripts
- ✅ Modify existing industrial control schedules
- ✅ Delete critical system schedulers
- ✅ Potential RCE through scheduler script execution
- ✅ Disruption of SCADA/ICS operations
###📋 Usage Examples
Example 1: Vulnerability Assessment

### Run vulnerable FUXA version
```bash
docker run -p 1881:1881 -d fuxa:v1.2.10
```
```bash
$ python CVE-2026-25939.py http://192.168.1.100:1881 --check
[*] Checking vulnerability status for http://192.168.1.100:1881
[*] Testing guest access to scheduler API...
[*] GET Response Status: 200
[*] Testing scheduler creation...
[*] POST Response Status: 200
[!] VULNERABLE: Target accepts unauthenticated scheduler creation
[!] This indicates version < 1.2.11
```
