# CVE-2026-25546 PoC - godot-mcp OS Command Injection

**Author:** Mohammed Idrees Banyamer  
**GitHub:** [mbanyamer](https://github.com/mbanyamer)  
**Date:** February 04, 2026

## Exploit Title
godot-mcp < 0.1.1 - OS Command Injection via `projectPath`

## CVE
**CVE-2026-25546**

## CWE
CWE-78 (Improper Neutralization of Special Elements used in an OS Command - OS Command Injection)

## Vendor
[Coding-Solo / godot-mcp](https://github.com/Coding-Solo/godot-mcp)

## Vulnerable Versions
< 0.1.1

## Fixed Version
0.1.1

## Patch Commit
[21c785d923cfdb471ea60323c13807d62dfecc5a](https://github.com/Coding-Solo/godot-mcp/commit/21c785d923cfdb471ea60323c13807d62dfecc5a)

## GHSA Reference
[GHSA-8jx2-rhfh-q928](https://github.com/Coding-Solo/godot-mcp/security/advisories/GHSA-8jx2-rhfh-q928)

## Severity
**High** (CVSS v3.1 Base Score: 7.8 – AV:L/AC:L/PR:N/UI:R/S:U/C:H/I:H/A:H)

## Description

godot-mcp versions prior to 0.1.1 are vulnerable to **OS Command Injection** due to unsafe string interpolation of the `projectPath` parameter when passed to Node.js `exec()` / `execAsync()` calls inside the `executeOperation()` function.

An attacker who can supply a malicious `projectPath` value (via MCP tool calls, prompt injection, malicious Godot project references, etc.) can execute arbitrary operating system commands with the privileges of the MCP server process.

This repository contains a **Python PoC** that demonstrates the vulnerability by calling the `create_scene` tool over WebSocket with a malicious `projectPath` payload.

## Proof-of-Concept (PoC)

### Requirements
- Python 3.10+
- `websockets` library (`pip install websockets`)

### Vulnerable Setup (Lab only!)
1. Clone the vulnerable version of godot-mcp
   ```bash
   git clone https://github.com/Coding-Solo/godot-mcp.git
   cd godot-mcp
   git checkout <commit-or-tag-before-fix>
   npm install
