# Llama Stack pgvector Password Leak PoC (CVE-2026-25211)

**Local Proof-of-Concept** demonstrating plaintext database password exposure in initialization logs of **llama-stack** versions **< 0.4.0rc3**.

![Python](https://img.shields.io/badge/python-3.8%2B-blue)
![License](https://img.shields.io/badge/license-MIT-green)
![CVE](https://img.shields.io/badge/CVE-2026--25211-red)

## Overview

In affected versions of **llama-stack** (before 0.4.0rc3), when using the **pgvector** vector store provider, the PostgreSQL database password is logged **in plaintext** during server or vector store initialization.

This information appears in:
- stdout / console output
- Docker container logs
- Kubernetes pod logs
- Custom log files

An attacker with **local access** to these logs (or via misconfiguration that exposes logs) can extract valid database credentials.

**CVSS**: 3.2 (Low) – AV:L / AC:H / PR:N / UI:N / S:C / C:L / I:N / A:N

**Fixed in**: v0.4.0rc3 and later (password is masked as `******` in logs)

## Features of this PoC

- Scans common log file locations
- Supports glob patterns (e.g. Docker container logs)
- Uses regex to detect password fields
- Shows context around matches for easy verification
- Works on Linux systems (tested in Docker and bare-metal environments)

**Important**: This is a **local-only** vulnerability. No remote exploitation is possible without additional misconfiguration.

## Requirements

- Python 3.8+
- No external dependencies (uses only standard library)

## Installation

```bash
# Clone the repository
git clone https://github.com/YOUR-USERNAME/llama-stack-pgvector-leak-poc.git
cd llama-stack-pgvector-leak-poc

# (optional) Create virtual environment
python3 -m venv venv
source venv/bin/activate   # On Windows: venv\Scripts\activate
