const { NodeVM } = require("vm2");
const payloads = require("./payload");

function run(code) {
  try {
    const vm = new NodeVM({
      sandbox: { Reflect },
    });

    const result = vm.run(`
      module.exports = (function(){
        "use strict";
        ${code}
      }).call(undefined)
    `);

    console.log("✅ EXECUTED:", result);
  } catch (e) {
    console.log("❌ BLOCKED:", e.message);
  }
}

console.log("\n=== Sandbox v1 (fix this) ===");
for (const p of payloads) {
  console.log("\n---", p.name, "---");
  run(p.code);
}
