const { NodeVM } = require("vm2");
const payloads = require("./payload");

function run(code) {
  try {
    const vm = new NodeVM({
      sandbox: { Reflect, process },
    });

    const result = vm.run(`
      module.exports = (function(){
        ${code}
      })()
    `);

    console.log("✅ EXECUTED:", result);
  } catch (e) {
    console.log("❌ BLOCKED:", e.message);
  }
}

console.log("\n=== Sandbox v0 (no fix) ===");
for (const p of payloads) {
  console.log("\n---", p.name, "---");
  run(p.code);
}
