# 🧪 Expression Sandbox Escape – Simulation Lab

一个用于演示 **JavaScript 表达式沙箱逃逸与补丁演进** 的最小化实验环境。

通过多个版本的 sandbox，实现从：

> 完全可逃逸 → 修补 this → 再修补 destructuring

同时保留新的绕过方式，帮助理解真实世界中漏洞与补丁的博弈过程。

------

## 📦 项目结构

```
.
├── payload.js        # 各类攻击 payload
├── sandbox_v0.js     # 原始易受攻击版本
├── sandbox_v1.js     # 修复 this 链
├── sandbox_v2.js     # 再修复 destructuring
```

------

## 🎯 设计目标

我们希望模拟这样的现实：

1. 安全团队修了一个洞
2. 攻击者换一条路径
3. 再修
4. 再被绕

不断循环。

**本项目不是为了做一个真正安全的 VM。**
 而是为了观察：

> 每一次“看似合理”的补丁，是如何被下一种技巧击穿的。

------

## 🚀 如何运行

```
npm install vm2 acorn acorn-walk
node sandbox_vX.js
```

把 `X` 换成 0 / 1 / 2。

------

## 🧨 Payload 说明

`payload.js` 内置四种访问方式：

| 名称                           | 技术                       |
| ------------------------------ | -------------------------- |
| CVE-2025-68613 / this          | 通过 this 获取 process     |
| CVE-2026-25049 / destructuring | 通过对象解构拿 constructor |
| Reflect.get                    | 使用 Reflect API           |
| Dynamic Reflect                | 动态属性访问               |

------

## 🏚 sandbox_v0 – 裸奔时代

特点：

- 没有限制 this
- 不检查解构
- 不做 AST 分析

结果：
 **全部 payload 都能通过。**

攻击者快乐得像过年。

------

## 🔧 sandbox_v1 – 修 this

变化：

- 强制 `"use strict"`
- `.call(undefined)`

因此：

```
this === undefined
```

### 被阻止

- CVE-2025-68613

### 仍然可以

- destructuring
- Reflect

攻击者点点头，换条路继续走。

------

## 🔒 sandbox_v2 – 修 destructuring

新增：

- AST 分析
- 专门检查 `ObjectPattern`
- 出现：
  - `constructor`
  - 或 computed key
     → 阻止执行

### 被阻止

- this
- destructuring

### 仍然可以

- Reflect.get
- Dynamic Reflect

------

## 🧠 这个实验真正想表达什么？

黑名单式修补通常具有：

✔ 修复明确路径
 ✔ 成本低
 ✔ 易上线

但同时：

❌ 防御面有限
 ❌ 很容易被语义等价的其它访问方式绕过

这正是为什么类似 vm2 的沙箱，历史上会反复出现逃逸。