# deephas <= 1.0.7 – Prototype Pollution PoC (CVE-2026-25047)

**Exploit Title:** deephas <= 1.0.7 - Prototype Pollution leading to Arbitrary Code Execution / DoS  
**CVE:** CVE-2026-25047  
**GHSA:** GHSA-2733-6c58-pf27  
**CVSS:** 9.8 (Critical)  
**Author:** Mohammed Idrees Banyamer  
**Author Country:** Jordan  
**Contact:** Instagram [@banyamer_security](https://instagram.com/banyamer_security)  
**Date:** February 01, 2026  
**Tested on:** Node.js 16 / 18 / 20 (Linux / macOS / Windows)

## Description

The `deephas` npm package (versions <= 1.0.7) is vulnerable to **prototype pollution** due to unsafe recursive property assignment in the `set()` function without proper safeguards against `__proto__` and `constructor.prototype` paths.

An attacker controlling input to `deephas.set(obj, path, value)` can pollute `Object.prototype`, potentially leading to:

- Remote Code Execution (RCE) — e.g., polluting `process.env`, `require.extensions`, or other sensitive globals
- Denial of Service (DoS)
- Security bypass (overriding `hasOwnProperty`, `toString`, etc.)
- Privilege escalation in sandboxed environments (e.g., vm2)

This repository contains a clean **Proof-of-Concept (PoC)** Python script that demonstrates the vulnerability using two bypass techniques:

1. `constructor.prototype` path + `hasOwnProperty` override bypass  
2. `__proto__` path + `indexOf` override bypass  

The issue was fixed in **deephas >= 1.0.8**.

**References:**
- [GitHub Advisory (GHSA-2733-6c58-pf27)](https://github.com/sharpred/deepHas/security/advisories/GHSA-2733-6c58-pf27)
- [NVD CVE-2026-25047](https://nvd.nist.gov/vuln/detail/CVE-2026-25047)
- Original repository: [sharpred/deepHas](https://github.com/sharpred/deepHas)

## Requirements

- Python 3.x
- Node.js (16 / 18 / 20 recommended)
- `npm` to install the vulnerable package

## Installation & Usage

1. Clone this repository:
   ```bash
   git clone https://github.com/[your-username]/deephas-poc-cve-2026-25047.git
   cd deephas-poc-cve-2026-25047
   python3 poc-deephas-prototype-pollution.py ```
   
