# CVE-2026-24854 – ChurchCRM Authenticated Numeric SQL Injection (Logic Manipulation) PoC

Author: Mohammed Idrees Banyamer  
Country: Jordan  
Handle: @banyamer_security  
GitHub: https://github.com/mbanyamer  

---

## Overview

This repository contains a Proof of Concept (PoC) demonstrating an **authenticated numeric SQL injection vulnerability** in **ChurchCRM** versions prior to **6.7.2**.

The vulnerability allows **logic manipulation of SQL queries** by injecting non-numeric payloads into parameters assumed to be numeric, enabling unauthorized modification of query behavior (e.g., bypassing WHERE clauses).

- CVE ID: CVE-2026-24854  
- Vulnerability Type: Authenticated Numeric SQL Injection (Logic Manipulation)  
- Severity: High  
- Affected Versions: ChurchCRM < 6.7.2  
- Tested Version: 6.7.1  
- Fixed Version: 6.7.2  
- Fix Commit: 748f5084  
- Attack Vector: Authenticated Web Request  
- Authentication Required: Yes (low-privileged user sufficient)  

---

## Vulnerability Details

The vulnerability exists in the following file:

```
src/PaddleNumEditor.php
```

The POST parameter `PerID` is concatenated directly into multiple SQL queries without proper type casting or sanitization. Although intended to be numeric, it can be manipulated to alter SQL logic.

Example vulnerable pattern (conceptual):

```sql
DELETE FROM multibuy_mb WHERE mb_per_ID = $PerID AND mb_fr_ID = $frID;
```

By supplying a payload such as:

```
0 OR 1=1 -- 
```

the WHERE clause logic can be bypassed, potentially transforming a single-record operation into a **multi-record or full-table operation**.

This vulnerability is **not designed for blind data extraction**, but for **logic abuse** affecting UPDATE, DELETE, or INSERT operations.

---

## Impact

An authenticated attacker can:

- Delete multiple or all records instead of one
- Modify records outside their authorization scope
- Manipulate fundraiser or participant data
- Cause data integrity loss
- Abuse business logic without triggering typical SQLi alarms

Because this flaw occurs in **numeric-only logic**, it may bypass basic SQL injection detection and WAF rules.

---

## Proof of Concept

The PoC demonstrates:

### Step 1 – Normal Request
A legitimate request using a numeric `PerID` that affects only one record.

### Step 2 – Manipulated Request
A crafted numeric SQL injection payload:

```
0 OR 1=1 -- 
```

This payload bypasses WHERE clause restrictions, resulting in multi-record or full-table effects (e.g., mass deletion).

The PoC compares HTTP responses and behavioral differences to confirm successful manipulation.

---

## Usage

### Requirements

- Python 3
- requests library
- Vulnerable ChurchCRM instance (< 6.7.2)
- Valid authenticated user account

Install dependency:

```bash
pip install requests
```

---

### Configuration

Edit the following variables in the PoC script:

```python
TARGET_BASE = "http://localhost/churchcrm"
USERNAME    = "admin"
PASSWORD    = "yourpassword"
```

⚠️ **Use only a local or authorized test instance**

---

### Running the PoC

```bash
python3 churchcrm_cve-2026-24854_poc.py
```

---

### Verification

To confirm exploitation:

- Observe differences between normal and manipulated responses
- Check affected database tables (e.g., `multibuy_mb`) before and after
- Validate unexpected multi-row DELETE/UPDATE behavior

The `is_success_response()` function can be tuned to match your instance’s normal vs manipulated responses.

---

## Patch Status

The issue was fixed in **ChurchCRM 6.7.2** via commit:

```
748f5084
```

Fix details:

- Explicit `(int)` casting applied to:
  - `PerID`
  - `Num`
  - Related identifiers
- Non-numeric input is coerced to `0`, preventing injection

Users should **upgrade immediately**.

---

## Mitigation Recommendations

- Enforce strict type casting on all numeric inputs
- Use prepared statements instead of string-concatenated SQL
- Apply least-privilege permissions to authenticated users
- Add server-side authorization checks for record ownership
- Log and alert on anomalous bulk operations

---

## Responsible Disclosure

This vulnerability was discovered and responsibly disclosed by:

Mohammed Idrees Banyamer  
Jordan  
Instagram: @banyamer_security  
GitHub: https://github.com/mbanyamer  

---

## Disclaimer

This Proof of Concept is provided for **educational and defensive security purposes only**.

Do NOT use this code against systems you do not own or have explicit permission to test.

The author assumes no liability for misuse or damages resulting from this code.

---

## References

- ChurchCRM Website: https://churchcrm.io  
- ChurchCRM GitHub: https://github.com/ChurchCRM/CRM  
- CVE: CVE-2026-24854  

---
