# CVE-2026-24688 - pypdf - Circular Reference DoS Vulnerability

This repo includes proof of concept code for triggering CVE-2026-24688.

## Summary

Critical Denial of Service vulnerability in pypdf's outline (bookmark) parsing logic. When processing a PDF with circular outline references, the parser enters an infinite loop that continuously allocates memory, consuming hundreds of MBs memory per seconds, on my machine (TM), and lead to complete system crash.

**This is a system-level DoS, not just an application hang.**

---

## Contents

- `malicious_circular_outline.pdf` - Exploit PDF with circular outline (754 bytes)
- `create_malicious_pdf.py` - Script to generate the exploit PDF
- `simple_read_pdf.py` - Simple test script to reproduce the vulnerability
- `test_pypdf.sh` - Automated test script (installs pypdf and runs test)
- `README.md` - This file

---

**WARNING:** These tests may crash your system if you dont keep an eye on memory consumption and cancel it in time.

---

### Automated Test (UNSAFE)
```bash
# Run the automated test script (with timeout protection)
chmod +x test_pypdf.sh
./test_pypdf.sh

# This will:
# 1. Install the vulnerable version of pypdf
# 2. Run test with 15-second timeout
# 3. Show memory consumption behavior
```

### Manual Tests

#### Test 1: Controlled Test (10 seconds with timeout)
```bash
# Install pypdf (vulnerable version 6.6.0)
pip install "pypdf==6.6.0"

# Run with timeout
timeout 10s python3 simple_read_pdf.py malicious_circular_outline.pdf
```

#### Test 2: Full Crash Test (UNSAFE)
```bash
# Install pypdf (vulnerable version 6.6.0)
pip install "pypdf==6.6.0"

# Run without timeout
python3 simple_read_pdf.py malicious_circular_outline.pdf
```

---

## Vulnerability Details

### Vulnerable Code

**Location:** [`pypdf/_doc_common.py` - `_get_outline()` method (lines 858-873)](https://github.com/py-pdf/pypdf/blob/main/pypdf/_doc_common.py#L858-L873)

```python
def _get_outline(self, node, outline=None):
    while True:  # ❌ NO cycle detection!
        outline_obj = self._build_outline_item(node)
        if outline_obj:
            outline.append(outline_obj)  # ❌ Heap allocation in loop!
        
        if "/Next" not in node:
            break
        node = node["/Next"]  # ❌ Follows circular references
```

**Root Cause:** No visited set, no iteration limit, continuous memory allocation

---

## Impact

### Confirmed Test Results

**Real-World Test:**
- Result: System crash, hard reboot required
- Timeline: ~5 minutes to complete system failure ()
- Memory: 30GB+ consumed
- CPUs: All cores 100% (system thrashing)

**Attack Characteristics:**
- ✅ 100% CPU (immediate)
- ✅ Linear memory growth
- ✅ System-wide failure
- ✅ Hard reboot required
- ✅ Potential data loss

---

## Fix

Fixed in version 6.6.2

https://github.com/py-pdf/pypdf/security/advisories/GHSA-2q4j-m29v-hq73
