#!/usr/bin/env bash

TERMINUS_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"

alias terminus="python3 -m terminus"

terminus_scan() {
    python3 -m terminus scan "$@"
}

terminus_passive() {
    python3 -m terminus scan --passive-only "$@"
}

terminus_verify() {
    python3 -m terminus scan --verify "$@"
}

terminus_exploit() {
    python3 -m terminus exploit "$@"
}

terminus_quick_scan() {
    if [ -z "$1" ]; then
        echo "Usage: terminus_quick_scan <target>"
        return 1
    fi
    python3 -m terminus scan -t "$1" -o terminal
}

terminus_verify_scan() {
    if [ -z "$1" ]; then
        echo "Usage: terminus_verify_scan <target>"
        return 1
    fi
    python3 -m terminus scan -t "$1" --verify -o terminal
}

terminus_bulk_verify() {
    if [ -z "$1" ]; then
        echo "Usage: terminus_bulk_verify <targets_file>"
        return 1
    fi
    python3 -m terminus scan -f "$1" --verify --threads 500 -o json -w "verified_$(date +%Y%m%d_%H%M%S).json"
}

terminus_setup_completion() {
    echo "Setting up tab completion for Terminus..."
    
    if [ -n "$BASH_VERSION" ]; then
        _TERMINUS_COMPLETE=bash_source terminus > ~/.terminus-complete.bash
        if ! grep -q "terminus-complete.bash" ~/.bashrc; then
            echo "source ~/.terminus-complete.bash" >> ~/.bashrc
        fi
        source ~/.terminus-complete.bash
        echo "Bash completion installed. Restart shell or run: source ~/.bashrc"
    elif [ -n "$ZSH_VERSION" ]; then
        _TERMINUS_COMPLETE=zsh_source terminus > ~/.terminus-complete.zsh
        if ! grep -q "terminus-complete.zsh" ~/.zshrc; then
            echo "source ~/.terminus-complete.zsh" >> ~/.zshrc
        fi
        source ~/.terminus-complete.zsh
        echo "Zsh completion installed. Restart shell or run: source ~/.zshrc"
    else
        echo "Unsupported shell. Please set up completion manually."
    fi
}

echo "Terminus helper functions loaded:"
echo "  terminus_scan <args>           - Run scan with custom args"
echo "  terminus_passive <target>      - Passive scan only"
echo "  terminus_verify <target>       - Active verification scan"
echo "  terminus_exploit <target>      - Exploit target"
echo "  terminus_quick_scan <target>   - Quick single target scan"
echo "  terminus_verify_scan <target>  - Quick verification scan"
echo "  terminus_bulk_verify <file>    - Bulk verification with JSON output"
echo "  terminus_setup_completion      - Install tab completion"
echo ""
echo "Example: terminus_verify_scan 192.168.1.100"
