# CVE-2026-23950

Proof of concept for CVE-2026-23950 - Race condition vulnerability in tar package.

## Description

This repository demonstrates a race condition vulnerability in the `tar` npm package (version 7.5.3) that allows for file collision during extraction. The vulnerability exploits Unicode normalization differences where `collision_ss` and `collision_ß` can be treated as the same file due to case-insensitive collisions.

## Vulnerability Details

- **CVE ID**: CVE-2026-23950
- **Affected Package**: tar
- **Affected Version**: 7.5.3
- **Vulnerability Type**: Race condition leading to file collision
- **Impact**: File content corruption/overwriting during parallel extraction

## How It Works

The exploit creates a tar archive with two files:
1. `collision_ss` - containing 1000 'A' characters
2. `collision_ß` - containing 1000 'B' characters

When extracted with parallel processing enabled (`jobs: 8`), the race condition can cause these files to collide, resulting in:
- Only one file being created
- Both filenames potentially pointing to the same inode
- Content from one file overwriting the other

## Setup

```bash
npm install
```

## Usage

```bash
node index.js
```

## Expected Output

If the race condition is successfully exploited:
- Files will share the same inode
- Output will display `[*] GOOD`

If the vulnerability is not triggered:
- Two separate files will be created
- Output will display `[-] No collision`

## Impact

This vulnerability could lead to:
- Data loss or corruption
- Security bypasses if file content verification is performed after extraction
- Unexpected application behavior due to missing or corrupted files

## Remediation

Update to a patched version of the tar package when available.

## Disclaimer

This code is for educational and research purposes only. Do not use this exploit for malicious purposes.
