# CVE-2026-23745: node-tar Arbitrary File Overwrite

**Research:** [Joshua van Rijswijk](https://github.com/Jvr2022)

## Description

PoC for **CVE-2026-23745**, a high-severity path traversal vulnerability in `node-tar` ( `<7.5.2`).

The library fails to sanitize absolute paths in the `linkpath` field for Hardlinks and Symlinks. This allows malicious tar archives to bypass the extraction root and overwrite arbitrary files on the host system, even when `preservePaths: false` is set.

## The Vulnerability

Located in `src/unpack.ts`. The library uses `path.resolve()` on unsanitized user input:

```javascript
// The bug: path.resolve ignores 'cwd' if the second argument is absolute
const target = path.resolve(this.cwd, String(entry.linkpath))

```

If an attacker provides an absolute path (e.g., `/etc/passwd`) in the tar header, `node-tar` resolves it to the system root instead of the extraction directory.

## PoC Usage

The included `poc.js` generates a malicious archive and attempts to overwrite a local `secret.txt` file.

1. **Install vulnerable version:**
`npm install tar@7.5.2`

2. **Run exploit generator:**
`node poc.js`

**Output:**

```text
[+] VULN CONFIRMED: Hardlink overwrite successful
    Target file content changed to: OVERWRITTEN

```

## Fix

Patched in **v7.5.3**. The update adds `stripAbsolutePath()` to sanitize link targets before resolution.

**References:**

* [NVD - CVE-2026-23745](https://nvd.nist.gov/vuln/detail/CVE-2026-23745)
* [GitHub Advisory](https://github.com/isaacs/node-tar/security/advisories/GHSA-8qq5-rm4j-mr97)
