#  Description

MCPJam inspector is the local-first development platform for MCP servers. Versions 1.4.2 and earlier are vulnerable to remote code execution (RCE) vulnerability, which allows an attacker to send a crafted HTTP request that triggers the installation of an MCP server, leading to RCE. Since MCPJam inspector by default listens on 0.0.0.0 instead of 127.0.0.1, an attacker can trigger the RCE remotely via a simple HTTP request. Version 1.4.3 contains a patch.
# Affected Versions

| **Vulnerability Source** | **Affected Versions** | **Patched Versions** |
| :--- | :--- | :--- |
| [`@mcpjam/inspector`](https://github.com/advisories/GHSA-232v-j27c-5pp6) | <= 1.4.2 | 1.4.3 

# Proof of Concept

### 1. Start up the MCPJam inspector

```bash
npx @mcpjam/inspector@1.4.2
```


### 2. Run Python Script

```bash
python3 exploit.py <target_ip> 'id > /tmp/mcpjam_pwned.txt'
```


### Screenshots

![[Pasted image 20260120135006.png]](https://github.com/boroeurnprach/CVE-2026-23744-PoC/blob/main/Assets/Pasted%20image%2020260120135006.png)
**In victim server:**
![[Pasted image 20260120135151.png]](https://github.com/boroeurnprach/CVE-2026-23744-PoC/blob/main/Assets/Pasted%20image%2020260120135151.png)
![[Pasted image 20260120150109.png]](https://github.com/boroeurnprach/CVE-2026-23744-PoC/blob/main/Assets/Pasted%20image%2020260120150109.png)
