# 🛡️ CVE-2026-22807 Simulation: AI Supply Chain RCE Target Range

> **⚠️ 免责声明 / Disclaimer**
>
> 本项目仅用于**安全研究与教学目的**，旨在演示 AI 模型加载过程中的供应链攻击原理（Remote Code Execution）。
> 请勿在生产环境中使用生成的恶意模型，也严禁将本项目用于任何非法攻击行为。开发者不承担任何因使用不当造成的法律责任。

## 📖 项目简介 (Introduction)

这是一个轻量级的 Python 靶场，用于模拟和复现 **CVE-2026-22807**（一个典型的 AI 供应链漏洞逻辑）。

该靶场演示了当 AI 推理框架（如 vLLM, Transformers 等）在加载模型时的**时序竞争（TOCTOU）**问题：
如果加载器在检查 `trust_remote_code=False` 之前，为了解析模型架构（AutoConfig/AutoModel）而过早地导入了用户提供的 Python 代码，攻击者即可绕过安全检查实现**远程代码执行（RCE）**。

### 核心特性
* ❌ **模拟脆弱逻辑**：复刻了“先解析代码，后检查权限”的错误设计。
* 💣 **动态 Payload 生成**：支持通过命令行参数注入自定义的系统命令。
* 🚀 **零依赖**：不需要安装 PyTorch 或 vLLM，仅需 Python 标准库即可运行验证。

## 📂 文件结构 (Files)

| 文件名                | 角色                | 描述                                                         |
| :-------------------- | :------------------ | :----------------------------------------------------------- |
| `vulnerable_lib.py`   | 🎯 靶子 (Victim)     | 模拟存在漏洞的 AI 模型加载器库 (`MiniLLM`)。包含错误的逻辑顺序。 |
| `poc_dynamic.py`      | 🔫 攻击者 (Attacker) | 自动化攻击脚本。负责生成恶意模型目录并触发加载过程。         |
| `dynamic_evil_model/` | 📦 恶意载荷          | 脚本运行后自动生成的目录，包含 `config.json` 和被注入代码的 `malicious.py`。 |

## 🛠️ 快速开始 (Quick Start)

### 1. 环境准备
确保已安装 Python 3.x。本靶场无第三方库依赖。

### 2. 基础验证

直接运行攻击脚本，默认执行 `whoami` 命令。

```
python poc_dynamic.py
```

**预期输出：** 你将看到控制台打印出 `PWNED` 字样以及当前的系统用户名，随后程序才会抛出 "Remote code not allowed" 的异常。这证明防御已被绕过。

### 3. 高级利用 (自定义命令)

你可以将任意系统命令作为参数传递给脚本，生成特定的“炸弹”。

**Windows 示例 (弹出计算器):**

```
python poc_dynamic.py calc
```

**Linux/Mac 示例 (查看文件):**

```
python poc_dynamic.py cat /etc/passwd
```

## 🔍 漏洞原理分析 (Technical Analysis)

### 漏洞逻辑流

该靶场复现了以下危险流程：

1. **加载配置**：加载器读取 `config.json`。
2. **解析架构 (Vulnerability)**：加载器发现 `auto_map` 字段，为了确认模型类，直接执行 `importlib` 导入目标 Python 文件。
3. **代码执行 (Exploit)**：由于 Python 的 `import` 机制，恶意文件顶层的 `os.system()` 被立即执行。
4. **安全检查 (Bypass)**：代码执行完毕后，加载器才检查 `trust_remote_code`。虽然此时拦截并报错，但攻击已经完成。

### 核心代码对比

**❌ 脆弱代码 (`vulnerable_lib.py`):**

```
# 1. 先触发代码加载 (RCE 发生在这里)
self._resolve_model_class() 

# 2. 后进行安全检查 (亡羊补牢)
if not self.trust_remote_code:
    raise RuntimeError("Aborted!")
```

**✅ 修复方案:**

```
# 1. 先进行安全检查
if not self.trust_remote_code and self._needs_remote_code():
    raise RuntimeError("Aborted!")

# 2. 检查通过后才加载代码
self._resolve_model_class()
```