# Termix Stored XSS PoC (GHSA-m3cv-5hgp-hv35)

This repository contains a Proof of Concept (PoC) exploit for the Stored Cross-Site Scripting (XSS) vulnerability in Termix, which can lead to Local File Inclusion (LFI) in the Electron environment and Session Hijacking.

## Vulnerability Details
- **Advisory**: GHSA-m3cv-5hgp-hv35
- **Component**: File Manager (FileViewer.tsx)
- **Root Cause**: Unsafe rendering of SVG files using `dangerouslySetInnerHTML`.
- **Impact**: Attackers can execute arbitrary JavaScript by uploading a malicious SVG file. In the Electron app, this allows bypassing SOP to read local files (LFI) or stealing session tokens (JWT/Cookies).

## Prerequisites
- **Target OS**: Linux / macOS / Windows
- **Dependencies**: Python 3, Node.js (for running the target app)
- **Python Libraries**: `requests`

## Setup & installation

1. **Install Python dependencies**:
   ```bash
   python3 -m venv .venv
   source .venv/bin/activate
   pip3 install requests
   ```

2. **Setup the Target Application (Termix)**:
   Ensure you have the vulnerable version of Termix (Release 1.9.0) extracted.
   **Note: The exploit is designed to work with Termix Release 1.7.0 - 1.9.0.**
   ```bash 
   wget https://github.com/Termix-SSH/Termix/archive/refs/tags/release-1.9.0-tag.zip
   unzip release-1.9.0-tag.zip
   ```
   **Terminal 1 (Backend):**
   ```bash
   cd Termix-release-1.9.0-tag
   npm install
   npm run dev:backend
   ```
   *Wait until the backend server is fully started.*

   **Terminal 2 (Frontend/Electron):**
   ```bash
   cd Termix-release-1.9.0-tag
   npm run electron:dev
   ```
   *The Termix application window should open.*

3. **Setup SSH Access (Localhost)**:
   The exploit connects to the victim's SSH server to upload the malicious file.
   Ensure you have an SSH server running on port 22 or adjust the script accordingly.
   User `kali` with the provided authorized key (or password) is used in the default config.

## Running the Exploit

1. **Execute the Exploit Script**:
   Open a new terminal and run:
   ```bash
   python3 exploit.py --user 'USERNAME' --pass 'PASSWORD'
   ```
   *Note: data provided matches the default credentials or the ones you registered.*

2. **Trigger the XSS**:
   - Go to the **Termix Application**.
   - Navigate to the **File Manager**.
   - Go to `/home/kali` (or where the file was uploaded).
   - Click on **`cookie_stealer.svg`** to view it.

3. **Verify Success**:
   - A visual overlay (Purple Box) should appear saying **"SESSION HIJACKED!"**.
   - It will display the **JWT Token** (from `localStorage`) and **Cookies** inside the box.
   - An alert popup saying "Session Hijacking Successful!" should also appear.

## Exploit Code (`exploit.py`)
The script performs the following actions:
1. Authenticates with the Termix Backend API.
2. Creates a managed SSH host entry pointing to `localhost` (using generated SSH keys).
3. Connects to the SSH host via Termix's internal API.
4. Uploads a malicious SVG file (`cookie_stealer.svg`) containing the XSS payload.
   - **Payload**: Uses `<foreignObject>` to embed HTML/JS inside SVG.
   - **Vector**: `<img src="x" onerror="...">` triggers execution immediately upon rendering.

---
**Disclaimer**: This code is for educational and testing purposes only. Do not use against systems you do not own or have permission to test.
