# CVE-2026-22444

Apache Solr UNC Path Validation Vulnerability

## Overview

This vulnerability was discovered and disclosed to Apache in 2025. It affects Apache Solr's core creation functionality, where network access to UNC paths occurs before path validation checks are performed.
 On Windows systems running in standalone mode, this results in RCE when authentication is not enabled or the user has permissions to create cores.

## Disclosure

The vulnerability was reported to Apache and publicly disclosed on the oss-security mailing list:

**Official Advisory:** <https://www.openwall.com/lists/oss-security/2026/01/20/5>

## Technical Details

The vulnerability exists in `CoreContainer.java` where the `CoreDescriptor` constructor triggers network operations before UNC path validation:

- `instancePath.toAbsolutePath()` may resolve UNC paths over the network
- `Files.exists()` checks execute network calls
- `Files.newInputStream()` performs network reads
- Path validation via `assertPathAllowed()` occurs only after these operations

## Timeline

- **2025-08-20**: Vulnerability discovered and reported to Apache
- **2026-01-20**: Public disclosure

## Repository Contents

- `exploit.py` - Proof of concept exploit
- `files/` - Supporting files for exploitation (configset)
